"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesDashboardLink = exports.KubernetesDashboardCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _kubernetes_asset_image = require("./kubernetes_asset_image");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/kubernetes_dashboard_promotion/kubernetes_dashboard_promotion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const VIEW_DASHBOARDS_TEXT = _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.viewDashboardsLink', {
  defaultMessage: 'View Dashboards'
});
const VIEW_INTEGRATION_TEXT = _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.viewIntegrationLink', {
  defaultMessage: 'View Integration'
});
const DISMISS_TEXT = _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.dismiss', {
  defaultMessage: 'Dismiss'
});
const ECS_CONFIG = {
  integrationId: _constants.KUBERNETES_INTEGRATION_ID,
  card: {
    imageType: 'ecs',
    title: {
      installed: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.ecs.integrationInstalledTitle', {
        defaultMessage: 'View Kubernetes Dashboards'
      }),
      notInstalled: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.ecs.integrationNotInstalledTitle', {
        defaultMessage: 'Install Kubernetes Integration'
      })
    },
    description: {
      installed: integrationLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.kubernetesDashboardPromotion.ecs.integrationInstalledDescription",
        defaultMessage: "View dashboards available for the Kubernetes clusters observed using the {integrationLink} which match your query.",
        values: {
          integrationLink
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      }),
      notInstalled: integrationLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.kubernetesDashboardPromotion.ecs.integrationNotInstalledDescription",
        defaultMessage: "We have dashboards for Kubernetes clusters observed using the {integrationLink} which match your query.",
        values: {
          integrationLink
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 9
        }
      }),
      docsLink: {
        text: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.ecs.integrationDocsLinkText', {
          defaultMessage: 'Kubernetes Integration'
        }),
        testSubj: 'infraKubernetesDashboardCardIntegrationDocsLink'
      }
    },
    actionButton: {
      installed: {
        dashboardsPath: `#/list?_g=()&s=tag:(${_constants.KUBERNETES_INTEGRATION_TAG})`,
        label: VIEW_DASHBOARDS_TEXT,
        testSubj: 'infraKubernetesDashboardCardLink'
      },
      notInstalled: {
        integrationPath: `${_constants.INTEGRATION_PAGE_PATH}/${_constants.KUBERNETES_INTEGRATION_ID}`,
        label: VIEW_INTEGRATION_TEXT,
        testSubj: 'infraKubernetesDashboardCardInstallLink'
      }
    },
    hideButton: {
      label: DISMISS_TEXT,
      testSubj: 'infraKubernetesDashboardCardHideThisButton'
    }
  },
  link: {
    dashboardsPath: `#/list?_g=()&s=tag:(${_constants.KUBERNETES_INTEGRATION_TAG})`,
    label: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.ecs.bottomDrawerLink', {
      defaultMessage: 'Kubernetes Integration'
    }),
    testSubj: 'inventory-kubernetesDashboard-link'
  }
};
const SEMCONV_CONFIG = {
  integrationId: _constants.KUBERNETES_SEMCONV_INTEGRATION_ID,
  card: {
    imageType: 'semconv',
    title: {
      installed: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.semconv.integrationInstalledTitle', {
        defaultMessage: 'View Kubernetes OpenTelemetry Dashboards'
      }),
      notInstalled: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.semconv.integrationNotInstalledTitle', {
        defaultMessage: 'Install Kubernetes OpenTelemetry Dashboards'
      })
    },
    description: {
      installed: integrationLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.kubernetesDashboardPromotion.semconv.integrationInstalledDescription",
        defaultMessage: "View dashboards available for the Kubernetes clusters which are observed using {integrationLink} which match your query.",
        values: {
          integrationLink
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 9
        }
      }),
      notInstalled: integrationLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.kubernetesDashboardPromotion.semconv.integrationNotInstalledDescription",
        defaultMessage: "We have dashboards for Kubernetes clusters which are observed using {integrationLink} which match your query.",
        values: {
          integrationLink
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 9
        }
      }),
      docsLink: {
        text: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.semconv.integrationDocsLinkText', {
          defaultMessage: 'OpenTelemetry'
        }),
        testSubj: 'infraSemconvKubernetesDashboardCardIntegrationDocsLink'
      }
    },
    actionButton: {
      installed: {
        dashboardsPath: `#/list?_g=()&s=tag:(${_constants.KUBERNETES_SEMCONV_INTEGRATION_TAG})`,
        label: VIEW_DASHBOARDS_TEXT,
        testSubj: 'infraSemconvKubernetesDashboardCardLink'
      },
      notInstalled: {
        integrationPath: `${_constants.INTEGRATION_PAGE_PATH}/${_constants.KUBERNETES_SEMCONV_INTEGRATION_ID}`,
        label: VIEW_INTEGRATION_TEXT,
        testSubj: 'infraSemconvKubernetesDashboardCardInstallLink'
      }
    },
    hideButton: {
      label: DISMISS_TEXT,
      testSubj: 'infraSemconvKubernetesDashboardCardHideThisButton'
    }
  },
  link: {
    dashboardsPath: `#/list?_g=()&s=tag:(${_constants.KUBERNETES_SEMCONV_INTEGRATION_TAG})`,
    label: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.semconv.bottomDrawerLink', {
      defaultMessage: 'Kubernetes OpenTelemetry'
    }),
    testSubj: 'inventory-semconvKubernetesDashboard-link'
  }
};
const INTEGRATION_CONFIGS = {
  ecs: ECS_CONFIG,
  semconv: SEMCONV_CONFIG
};
const IntegrationLink = ({
  integrationId,
  text,
  testSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": testSubj,
    href: `${_constants.INTEGRATION_DOCS_LINK}/${integrationId}`,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, text);
};
const KubernetesDashboardCard = ({
  integrationType,
  onClose,
  hasIntegrationInstalled
}) => {
  const {
    card,
    integrationId
  } = INTEGRATION_CONFIGS[integrationType];
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    getUrlForApp
  } = services.application;
  const actionButton = hasIntegrationInstalled ? card.actionButton.installed : card.actionButton.notInstalled;
  const actionUrl = hasIntegrationInstalled ? getUrlForApp('dashboards', {
    path: card.actionButton.installed.dashboardsPath
  }) : getUrlForApp('integrations', {
    path: card.actionButton.notInstalled.integrationPath
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    color: "subdued",
    grow: true,
    borderRadius: "m",
    css: {
      display: 'flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_kubernetes_asset_image.KubernetesAssetImage, {
    type: card.imageType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 17
    }
  }, hasIntegrationInstalled ? card.title.installed : card.title.notInstalled))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 15
    }
  }, hasIntegrationInstalled ? card.description.installed(/*#__PURE__*/_react.default.createElement(IntegrationLink, {
    integrationId: integrationId,
    text: card.description.docsLink.text,
    testSubj: card.description.docsLink.testSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 23
    }
  })) : card.description.notInstalled(/*#__PURE__*/_react.default.createElement(IntegrationLink, {
    integrationId: integrationId,
    text: card.description.docsLink.text,
    testSubj: card.description.docsLink.testSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    responsive: false,
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "data-test-subj": actionButton.testSubj,
    href: actionUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 19
    }
  }, actionButton.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": card.hideButton.testSubj,
    color: "text",
    size: "s",
    onClick: onClose,
    "aria-label": card.hideButton.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 19
    }
  }, card.hideButton.label))))))));
};
exports.KubernetesDashboardCard = KubernetesDashboardCard;
const KubernetesDashboardLink = ({
  integrationType
}) => {
  const {
    link
  } = INTEGRATION_CONFIGS[integrationType];
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    getUrlForApp
  } = services.application;
  const dashboardUrl = getUrlForApp('dashboards', {
    path: link.dashboardsPath
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": link.label,
    "data-test-subj": link.testSubj,
    href: dashboardUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 5
    }
  }, link.label);
};
exports.KubernetesDashboardLink = KubernetesDashboardLink;