"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterExplanationCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _react2 = require("@emotion/react");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/filter_explanation_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FilterExplanationCallout = ({
  dashboardFilterAssetIdEnabled
}) => {
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: dashboardFilterAssetIdEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.customDashboards.filteredByCurrentAssetExplanation.tooltip', {
        defaultMessage: 'Filtered by'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        transparentBackground: true,
        css: (0, _react2.css)`
                        color: inherit;
                      `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 21
        }
      }, `${(0, _common.findInventoryFields)(entity.type).id}: ${entity.id}`)) : _i18n.i18n.translate('xpack.infra.customDashboards.notFilteredExplanation.tooltip', {
        defaultMessage: 'You can change this dashboard to filter by the {entityType} by editing the link for it',
        values: {
          entityType: entity.type
        }
      }),
      color: "primary",
      size: "m",
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, dashboardFilterAssetIdEnabled ? _i18n.i18n.translate('xpack.infra.customDashboards.filteredByCurrentAssetExplanation.message', {
      defaultMessage: 'This dashboard is filtered by the current {entityType}',
      values: {
        entityType: entity.type
      }
    }) : _i18n.i18n.translate('xpack.infra.customDashboards.notFilteredExplanation.message', {
      defaultMessage: 'This dashboard is not filtered by the {entityType} you are viewing',
      values: {
        entityType: entity.type
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};
exports.FilterExplanationCallout = FilterExplanationCallout;