"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSelector = DashboardSelector;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/dashboard_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardSelector({
  customDashboards,
  currentDashboardId,
  setCurrentDashboard,
  onRefresh
}) {
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    if (!currentDashboardId) {
      var _customDashboards$;
      setUrlState({
        dashboardId: (_customDashboards$ = customDashboards[0]) === null || _customDashboards$ === void 0 ? void 0 : _customDashboards$.dashboardSavedObjectId
      });
    }
  });
  (0, _react.useEffect)(() => {
    const preselectedDashboard = customDashboards.find(({
      dashboardSavedObjectId
    }) => dashboardSavedObjectId === currentDashboardId);
    // preselect dashboard
    if (preselectedDashboard) {
      setSelectedDashboard(preselectedDashboard);
      setCurrentDashboard(preselectedDashboard);
    }
  }, [customDashboards, currentDashboardId, setCurrentDashboard]);
  const onChange = (0, _react.useCallback)(newDashboardId => {
    setUrlState({
      dashboardId: newDashboardId
    });
    onRefresh();
  }, [onRefresh, setUrlState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    style: {
      minWidth: '200px'
    },
    placeholder: _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.placeholder', {
      defaultMessage: 'Select dashboard'
    }),
    prepend: _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.prepend', {
      defaultMessage: 'Dashboard'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: customDashboards.map(({
      dashboardSavedObjectId,
      title
    }) => {
      return {
        label: title,
        value: dashboardSavedObjectId
      };
    }),
    selectedOptions: selectedDashboard ? [{
      value: selectedDashboard.dashboardSavedObjectId,
      label: selectedDashboard.title
    }] : [],
    onChange: ([newItem]) => onChange(newItem.value),
    isClearable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
}