"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = ContextMenu;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ContextMenu({
  items
}) {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "infraDashboardsContextMenuButton",
      display: "base",
      size: "s",
      iconType: "boxesVertical",
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.contextMenu.moreLabel', {
        defaultMessage: 'More'
      }),
      onClick: togglePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: index,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }, item)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
}