"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveDashboardModal = SaveDashboardModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _use_dashboards_fetcher = require("../../../hooks/use_dashboards_fetcher");
var _use_custom_dashboards = require("../../../hooks/use_custom_dashboards");
var _use_asset_details_url_state = require("../../../hooks/use_asset_details_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/actions/save_dashboard_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SaveDashboardModal({
  onClose,
  onRefresh,
  currentDashboard,
  customDashboards,
  assetType
}) {
  var _currentDashboard$das;
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data: allAvailableDashboards,
    status
  } = (0, _use_dashboards_fetcher.useDashboardFetcher)();
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [assetNameEnabled, setAssetNameFiltersEnabled] = (0, _react.useState)((_currentDashboard$das = currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardFilterAssetIdEnabled) !== null && _currentDashboard$das !== void 0 ? _currentDashboard$das : true);
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(currentDashboard ? [{
    label: currentDashboard.title,
    value: currentDashboard.dashboardSavedObjectId
  }] : []);
  const {
    isUpdateLoading,
    updateCustomDashboard
  } = (0, _use_custom_dashboards.useUpdateCustomDashboard)();
  const {
    isCreateLoading,
    createCustomDashboard
  } = (0, _use_custom_dashboards.useCreateCustomDashboard)();
  const isEditMode = !!(currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.id);
  const loading = isUpdateLoading || isCreateLoading;
  const options = (0, _react.useMemo)(() => allAvailableDashboards === null || allAvailableDashboards === void 0 ? void 0 : allAvailableDashboards.map(dashboardItem => {
    var _customDashboards$som;
    return {
      label: dashboardItem.data.title,
      value: dashboardItem.id,
      disabled: (_customDashboards$som = customDashboards === null || customDashboards === void 0 ? void 0 : customDashboards.some(({
        dashboardSavedObjectId
      }) => dashboardItem.id === dashboardSavedObjectId)) !== null && _customDashboards$som !== void 0 ? _customDashboards$som : false
    };
  }), [allAvailableDashboards, customDashboards]);
  const onChange = (0, _react.useCallback)(() => setAssetNameFiltersEnabled(!assetNameEnabled), [assetNameEnabled]);
  const onSelect = (0, _react.useCallback)(newSelection => setSelectedDashboard(newSelection), []);
  const onClickSave = (0, _react.useCallback)(async function () {
    const [newDashboard] = selectedDashboard;
    try {
      if (!newDashboard.value) {
        return;
      }
      const dashboardParams = {
        assetType,
        dashboardSavedObjectId: newDashboard.value,
        dashboardFilterAssetIdEnabled: assetNameEnabled
      };
      const result = isEditMode && currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.id ? await updateCustomDashboard({
        ...dashboardParams,
        id: currentDashboard.id
      }) : await createCustomDashboard(dashboardParams);
      const getToastLabels = isEditMode ? getEditSuccessToastLabels : getLinkSuccessToastLabels;
      if (result && !(isEditMode ? isUpdateLoading : isCreateLoading)) {
        notifications.toasts.addSuccess(getToastLabels(newDashboard.label));
      }
      setUrlState({
        dashboardId: newDashboard.value
      });
      onRefresh();
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.infra.customDashboards.addFailure.toast.title', {
          defaultMessage: 'Error while adding "{dashboardName}" dashboard',
          values: {
            dashboardName: newDashboard.label
          }
        }),
        text: error.message
      });
    }
    onClose();
  }, [selectedDashboard, onClose, isEditMode, setUrlState, onRefresh, updateCustomDashboard, assetType, currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.id, assetNameEnabled, isUpdateLoading, notifications.toasts, createCustomDashboard, isCreateLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "infraSelectCustomDashboard",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, isEditMode ? _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.modalTitle.edit', {
    defaultMessage: 'Edit dashboard'
  }) : _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.modalTitle.link', {
    defaultMessage: 'Select dashboard'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    isDisabled: status === _use_fetcher.FETCH_STATUS.LOADING || isEditMode,
    placeholder: _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.placeholder', {
      defaultMessage: 'Select dashboard'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedDashboard,
    onChange: onSelect,
    isClearable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    css: {
      alignItems: 'center'
    },
    compressed: true,
    label: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: {
        marginRight: euiTheme.size.xs
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.infra.customDashboard.addDashboard.useContextFilterLabel', {
      defaultMessage: 'Filter by host name'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.infra.customDashboard.addDashboard.useContextFilterLabel.tooltip', {
        defaultMessage: 'Enabling this option will apply filters to the dashboard based on your chosen host.'
      }),
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 17
      }
    })),
    onChange: onChange,
    checked: assetNameEnabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraSelectDashboardCancelButton",
    onClick: onClose,
    isDisabled: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.cancel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraSelectDashboardButton",
    onClick: onClickSave,
    isLoading: loading,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, isEditMode ? _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.edit', {
    defaultMessage: 'Save'
  }) : _i18n.i18n.translate('xpack.infra.customDashboards.selectDashboard.add', {
    defaultMessage: 'Link dashboard'
  }))));
}
function getLinkSuccessToastLabels(dashboardName) {
  return {
    title: _i18n.i18n.translate('xpack.infra.customDashboards.linkSuccess.toast.title', {
      defaultMessage: 'Added "{dashboardName}" dashboard',
      values: {
        dashboardName
      }
    }),
    body: _i18n.i18n.translate('xpack.infra.customDashboards.linkSuccess.toast.text', {
      defaultMessage: 'Your dashboard is now visible in the asset details page.'
    })
  };
}
function getEditSuccessToastLabels(dashboardName) {
  return {
    title: _i18n.i18n.translate('xpack.infra.customDashboards.editSuccess.toast.title', {
      defaultMessage: 'Edited "{dashboardName}" dashboard',
      values: {
        dashboardName
      }
    }),
    body: _i18n.i18n.translate('xpack.infra.customDashboards.editSuccess.toast.text', {
      defaultMessage: 'Your dashboard link has been updated'
    })
  };
}