"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GotoDashboardLink = GotoDashboardLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/actions/goto_dashboard_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GotoDashboardLink({
  currentDashboard
}) {
  var _share$url$locators$g;
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const url = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
    dashboardId: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardSavedObjectId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraGotoDashboardGoToDashboardButton",
    color: "text",
    size: "s",
    iconType: "visGauge",
    href: url,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.infra.customDashboards.contextMenu.goToDashboard', {
    defaultMessage: 'Go to dashboard'
  }));
}