"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApmServices = void 0;
var _react = _interopRequireDefault(require("react"));
var _querystring = require("querystring");
var _rison = require("@kbn/rison");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apmTypes = require("@kbn/apm-types");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/links/link_to_apm_services.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LinkToApmServices = ({
  entityId
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const queryString = new URLSearchParams((0, _rison.encode)((0, _querystring.stringify)({
    kuery: `${_constants.APM_HOST_FILTER_FIELD}:"${entityId}" OR ${_apmTypes.HOST_NAME}:"${entityId}"`
  })));
  const linkToApmServices = http.basePath.prepend(`/app/apm/services?${queryString}`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.apmServicesLink.ariaLabel', {
      defaultMessage: 'Show all APM services'
    }),
    "data-test-subj": "infraAssetDetailsViewAPMShowAllServicesButton",
    size: "xs",
    flush: "both",
    href: linkToApmServices,
    iconSide: "right",
    iconType: "sortRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.flyout.viewApmServicesLinkLabel",
    defaultMessage: "Show all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.LinkToApmServices = LinkToApmServices;