"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateCustomDashboard = exports.useDeleteCustomDashboard = exports.useCreateCustomDashboard = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../hooks/use_tracked_promise");
var _custom_dashboards_api = require("../../../../common/http_api/custom_dashboards_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorMessages = {
  create: _i18n.i18n.translate('xpack.infra.linkDashboards.addFailure.toast.title', {
    defaultMessage: 'Error while linking dashboards'
  }),
  update: _i18n.i18n.translate('xpack.infra.updatingLinkedDashboards.addFailure.toast.title', {
    defaultMessage: 'Error while updating linked dashboards'
  }),
  delete: _i18n.i18n.translate('xpack.infra.deletingLinkedDashboards.addFailure.toast.title', {
    defaultMessage: 'Error while deleting linked dashboards'
  })
};
const useUpdateCustomDashboard = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onError = (0, _react.useCallback)(errorMessage => {
    if (errorMessage) {
      notifications.toasts.addDanger({
        title: errorMessages.update,
        text: errorMessage
      });
    }
  }, [notifications.toasts]);
  const [updateCustomDashboardRequest, updateCustomDashboard] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async ({
      assetType,
      id,
      dashboardSavedObjectId,
      dashboardFilterAssetIdEnabled
    }) => {
      const rawResponse = await http.fetch(`/api/infra/${assetType}/custom-dashboards/${id}`, {
        method: 'PUT',
        body: JSON.stringify({
          assetType,
          dashboardSavedObjectId,
          dashboardFilterAssetIdEnabled
        })
      });
      return (0, _ioTsUtils.decodeOrThrow)(_custom_dashboards_api.InfraCustomDashboardRT)(rawResponse);
    },
    onResolve: response => response,
    onReject: e => onError(e === null || e === void 0 ? void 0 : e.message)
  }, []);
  const isUpdateLoading = updateCustomDashboardRequest.state === 'pending';
  const hasUpdateError = updateCustomDashboardRequest.state === 'rejected';
  return {
    updateCustomDashboard,
    isUpdateLoading,
    hasUpdateError
  };
};
exports.useUpdateCustomDashboard = useUpdateCustomDashboard;
const useDeleteCustomDashboard = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onError = (0, _react.useCallback)(errorMessage => {
    if (errorMessage) {
      notifications.toasts.addDanger({
        title: errorMessages.delete,
        text: errorMessage
      });
    }
  }, [notifications.toasts]);
  const [deleteCustomDashboardRequest, deleteCustomDashboard] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async ({
      assetType,
      id
    }) => {
      const rawResponse = await http.fetch(`/api/infra/${assetType}/custom-dashboards/${id}`, {
        method: 'DELETE'
      });
      return (0, _ioTsUtils.decodeOrThrow)(_custom_dashboards_api.InfraDeleteCustomDashboardsResponseBodyRT)(rawResponse);
    },
    onResolve: response => response,
    onReject: e => onError(e === null || e === void 0 ? void 0 : e.message)
  }, []);
  const isDeleteLoading = deleteCustomDashboardRequest.state === 'pending';
  const hasDeleteError = deleteCustomDashboardRequest.state === 'rejected';
  return {
    deleteCustomDashboard,
    isDeleteLoading,
    hasDeleteError
  };
};
exports.useDeleteCustomDashboard = useDeleteCustomDashboard;
const useCreateCustomDashboard = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onError = (0, _react.useCallback)(errorMessage => {
    if (errorMessage) {
      notifications.toasts.addDanger({
        title: errorMessages.delete,
        text: errorMessage
      });
    }
  }, [notifications.toasts]);
  const [createCustomDashboardRequest, createCustomDashboard] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async ({
      assetType,
      dashboardSavedObjectId,
      dashboardFilterAssetIdEnabled
    }) => {
      const rawResponse = await http.fetch(`/api/infra/${assetType}/custom-dashboards`, {
        method: 'POST',
        body: JSON.stringify({
          dashboardSavedObjectId,
          dashboardFilterAssetIdEnabled
        })
      });
      return (0, _ioTsUtils.decodeOrThrow)(_custom_dashboards_api.InfraCustomDashboardRT)(rawResponse);
    },
    onResolve: response => response,
    onReject: e => onError(e === null || e === void 0 ? void 0 : e.message)
  }, []);
  const isCreateLoading = createCustomDashboardRequest.state === 'pending';
  const hasCreateError = createCustomDashboardRequest.state === 'rejected';
  return {
    createCustomDashboard,
    isCreateLoading,
    hasCreateError
  };
};
exports.useCreateCustomDashboard = useCreateCustomDashboard;