"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityDetailsTimeRangeMetadataProvider = EntityDetailsTimeRangeMetadataProvider;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_time_range_metadata = require("../../hooks/use_time_range_metadata");
var _use_date_picker = require("./hooks/use_date_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/entity_details_metadata_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EntityDetailsTimeRangeMetadataProvider({
  entityType,
  entityId,
  children
}) {
  const {
    getParsedDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const parsedDateRange = getParsedDateRange();
  if (entityType !== 'host') return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const {
    id
  } = (0, _common.findInventoryFields)(entityType);
  return /*#__PURE__*/_react.default.createElement(_use_time_range_metadata.TimeRangeMetadataProvider, {
    dataSource: entityType,
    start: parsedDateRange.from,
    end: parsedDateRange.to,
    kuery: `${id}:"${entityId}"`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, children);
}