"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSnapshotMetricType = exports.Callouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_asset_details_url_state = require("../hooks/use_asset_details_url_state");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _legacy_metric_callout = require("./callouts/legacy_metric_callout");
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/content/callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INCOMING_ALERT_CALLOUT_VISIBLE_FOR = [_types.ContentTabIds.OVERVIEW, _types.ContentTabIds.METRICS];
const isSnapshotMetricType = value => {
  return value != null && value in _common.SnapshotMetricTypeKeys;
};
exports.isSnapshotMetricType = isSnapshotMetricType;
const Callouts = () => {
  var _entityConfig$metrics;
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [state] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const entityConfig = (0, _common.findInventoryModel)(entity.type);
  const alertMetric = isSnapshotMetricType(state === null || state === void 0 ? void 0 : state.alertMetric) ? state === null || state === void 0 ? void 0 : state.alertMetric : undefined;
  if (entity.type === 'host' && alertMetric && (_entityConfig$metrics = entityConfig.metrics.legacyMetrics) !== null && _entityConfig$metrics !== void 0 && _entityConfig$metrics.includes(alertMetric)) {
    return /*#__PURE__*/_react.default.createElement(_legacy_metric_callout.LegacyAlertMetricCallout, {
      visibleFor: INCOMING_ALERT_CALLOUT_VISIBLE_FOR,
      metric: alertMetric,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    });
  }
  return null;
};
exports.Callouts = Callouts;