"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LABEL_LABEL = exports.LABEL_HELP_MESSAGE = exports.EQUATION_HELP_MESSAGE = exports.DELETE_LABEL = exports.CUSTOM_EQUATION = exports.AGGREGATION_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EQUATION_HELP_MESSAGE = exports.EQUATION_HELP_MESSAGE = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.equationHelpMessage', {
  defaultMessage: 'Supports basic math expressions'
});
const LABEL_LABEL = exports.LABEL_LABEL = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.labelLabel', {
  defaultMessage: 'Label (optional)'
});
const LABEL_HELP_MESSAGE = exports.LABEL_HELP_MESSAGE = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.labelHelpMessage', {
  defaultMessage: 'Custom label will show on the alert chart and in reason/alert title'
});
const CUSTOM_EQUATION = exports.CUSTOM_EQUATION = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquation', {
  defaultMessage: 'Custom equation'
});
const DELETE_LABEL = exports.DELETE_LABEL = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.deleteRowButton', {
  defaultMessage: 'Delete'
});
const AGGREGATION_LABEL = name => _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.aggregationLabel', {
  defaultMessage: 'Aggregation {name}',
  values: {
    name
  }
});
exports.AGGREGATION_LABEL = AGGREGATION_LABEL;