"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoDataBehaviorValue = exports.defaultExpression = exports.default = exports.Expressions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _alertingComparators = require("@kbn/alerting-comparators");
var _public2 = require("@kbn/observability-plugin/public");
var _unified_search_bar = require("../../../components/shared/unified_search_bar");
var _metrics = require("../../../../common/alerting/metrics");
var _metrics_source = require("../../../containers/metrics_source");
var _group_by = require("../../../pages/metrics/metrics_explorer/components/group_by");
var _kuery = require("../../../utils/kuery");
var _expression_row = require("./expression_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultExpression = exports.defaultExpression = {
  aggType: _metrics.Aggregators.AVERAGE,
  comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
  threshold: [],
  timeSize: 1,
  timeUnit: 'm'
};
const getNoDataBehaviorOptions = hasGroupBy => [{
  id: 'recover',
  label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.metricThreshold.rule.noDataBehavior.recover', {
    defaultMessage: 'Recover active alerts'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "question",
    color: "subdued",
    content: _i18n.i18n.translate('xpack.infra.metricThreshold.rule.recoverHelpText', {
      defaultMessage: "Recover any active alerts when data isn't returned for the specified conditions. New alerts won't be created for the missing data."
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }))
}, {
  id: 'alertOnNoData',
  label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.metricThreshold.rule.noDataBehavior.alertOnNoData', {
    defaultMessage: 'Alert me about the missing data'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "question",
    color: "subdued",
    content: hasGroupBy ? _i18n.i18n.translate('xpack.infra.metricThreshold.rule.groupDisappearHelpText', {
      defaultMessage: 'Get a "no data" alert when a previously detected group stops returning data. This option is not suitable for dynamically scaling infrastructures that may rapidly start and stop nodes automatically.'
    }) : _i18n.i18n.translate('xpack.infra.metricThreshold.rule.noDataHelpText', {
      defaultMessage: 'Get a "no data" alert when data isn\'t returned during the rule execution period or if the rule does not successfully query Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }))
}, {
  id: 'remainActive',
  label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.metricThreshold.rule.noDataBehavior.remainActive', {
    defaultMessage: 'Do nothing'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "question",
    color: "subdued",
    content: _i18n.i18n.translate('xpack.infra.metricThreshold.rule.remainActiveHelpText', {
      defaultMessage: 'Keep active alerts in their current state, and do not create new alerts for the missing data.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }))
}];
const getNoDataBehaviorValue = (ruleParams, hasGroupBy) => {
  if (ruleParams.noDataBehavior) {
    return ruleParams.noDataBehavior;
  }

  // Derive from legacy params for backwards compatibility
  if (hasGroupBy) {
    return ruleParams.alertOnGroupDisappear ? 'alertOnNoData' : 'recover';
  }
  return ruleParams.alertOnNoData ? 'alertOnNoData' : 'recover';
};
exports.getNoDataBehaviorValue = getNoDataBehaviorValue;
const Expressions = props => {
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata
  } = props;
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const [timeSize, setTimeSize] = (0, _react.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react.useState)('m');
  const hasGroupBy = (0, _react.useMemo)(() => Boolean(ruleParams.groupBy && ruleParams.groupBy.length > 0), [ruleParams.groupBy]);
  const options = (0, _react.useMemo)(() => {
    var _metadata$currentOpti;
    if (metadata !== null && metadata !== void 0 && (_metadata$currentOpti = metadata.currentOptions) !== null && _metadata$currentOpti !== void 0 && _metadata$currentOpti.metrics) {
      return metadata.currentOptions;
    } else {
      return {
        metrics: [],
        aggregation: 'avg'
      };
    }
  }, [metadata]);
  const updateParams = (0, _react.useCallback)((id, e) => {
    const exp = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    exp[id] = e;
    setRuleParams('criteria', exp);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react.useCallback)(() => {
    var _ruleParams$criteria;
    const exp = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    exp.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', exp);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react.useCallback)(id => {
    var _ruleParams$criteria2;
    const exp = ((_ruleParams$criteria2 = ruleParams.criteria) === null || _ruleParams$criteria2 === void 0 ? void 0 : _ruleParams$criteria2.slice()) || [];
    if (exp.length > 1) {
      exp.splice(id, 1);
      setRuleParams('criteria', exp);
    }
  }, [setRuleParams, ruleParams.criteria]);
  const onFilterChange = (0, _react.useCallback)(payload => {
    var _payload$query;
    const kuery = (_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.query;
    setRuleParams('filterQueryText', kuery);
    try {
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(kuery, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, false) || '');
    } catch (e) {
      setRuleParams('filterQuery', _metrics.QUERY_INVALID);
    }
  }, [setRuleParams, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group && group.length ? group : '');
  }, [setRuleParams]);
  const emptyError = (0, _react.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    var _ruleParams$criteria3;
    const criteria = ((_ruleParams$criteria3 = ruleParams.criteria) === null || _ruleParams$criteria3 === void 0 ? void 0 : _ruleParams$criteria3.map(c => ({
      ...c,
      timeSize: ts
    }))) || [];
    setTimeSize(ts || undefined);
    setRuleParams('criteria', criteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    var _ruleParams$criteria4;
    const criteria = ((_ruleParams$criteria4 = ruleParams.criteria) === null || _ruleParams$criteria4 === void 0 ? void 0 : _ruleParams$criteria4.map(c => ({
      ...c,
      timeUnit: tu
    }))) || [];
    setTimeUnit(tu);
    setRuleParams('criteria', criteria);
  }, [ruleParams.criteria, setRuleParams]);
  const preFillAlertCriteria = (0, _react.useCallback)(() => {
    var _md$currentOptions, _md$currentOptions$me;
    const md = metadata;
    if (md !== null && md !== void 0 && (_md$currentOptions = md.currentOptions) !== null && _md$currentOptions !== void 0 && (_md$currentOptions$me = _md$currentOptions.metrics) !== null && _md$currentOptions$me !== void 0 && _md$currentOptions$me.length) {
      setRuleParams('criteria', md.currentOptions.metrics.map(metric => ({
        metric: metric.field,
        comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
        threshold: [],
        timeSize,
        timeUnit,
        aggType: metric.aggregation
      })));
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
  }, [metadata, setRuleParams, timeSize, timeUnit]);
  const preFillAlertFilter = (0, _react.useCallback)(() => {
    var _md$currentOptions2, _md$currentOptions3;
    const md = metadata;
    if (md && (_md$currentOptions2 = md.currentOptions) !== null && _md$currentOptions2 !== void 0 && _md$currentOptions2.filterQuery) {
      setRuleParams('filterQueryText', md.currentOptions.filterQuery);
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(md.currentOptions.filterQuery, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference) || '');
    } else if (md && (_md$currentOptions3 = md.currentOptions) !== null && _md$currentOptions3 !== void 0 && _md$currentOptions3.groupBy && md.series) {
      const {
        groupBy
      } = md.currentOptions;
      const filter = Array.isArray(groupBy) ? groupBy.map((field, index) => {
        var _md$series, _md$series$keys;
        return `${field}: "${(_md$series = md.series) === null || _md$series === void 0 ? void 0 : (_md$series$keys = _md$series.keys) === null || _md$series$keys === void 0 ? void 0 : _md$series$keys[index]}"`;
      }).join(' and ') : `${groupBy}: "${md.series.id}"`;
      setRuleParams('filterQueryText', filter);
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference) || '');
    }
  }, [metadata, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, setRuleParams]);
  const preFillAlertGroupBy = (0, _react.useCallback)(() => {
    var _md$currentOptions4;
    const md = metadata;
    if (md && (_md$currentOptions4 = md.currentOptions) !== null && _md$currentOptions4 !== void 0 && _md$currentOptions4.groupBy && !md.series) {
      setRuleParams('groupBy', md.currentOptions.groupBy);
    }
  }, [metadata, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      preFillAlertCriteria();
    }
    if (!ruleParams.filterQuery) {
      preFillAlertFilter();
    }
    if (!ruleParams.groupBy) {
      preFillAlertGroupBy();
    }
    if (!ruleParams.sourceId) {
      setRuleParams('sourceId', (source === null || source === void 0 ? void 0 : source.id) || 'default');
    }
    if (typeof ruleParams.noDataBehavior === 'undefined') {
      setRuleParams('noDataBehavior', getNoDataBehaviorValue(ruleParams, hasGroupBy));
    }
  }, [metadata, source]); // eslint-disable-line react-hooks/exhaustive-deps

  const handleFieldSearchChange = (0, _react.useCallback)(e => onFilterChange({
    query: {
      query: e.target.value,
      language: 'kuery'
    }
  }), [onFilterChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.conditions",
    defaultMessage: "Conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 7
    }
  }), metricsView && ruleParams.criteria.map((e, idx) => {
    let metricExpression = [{
      aggType: e.aggType,
      // RuleConditionChart uses A,B,C etc in its parser to identify multiple conditions
      name: String.fromCharCode('A'.charCodeAt(0) + idx),
      field: e.metric || ''
    }];
    if (e.customMetrics) {
      metricExpression = e.customMetrics.map(metric => ({
        name: metric.name,
        aggType: metric.aggType,
        field: metric.field || '',
        filter: metric.filter
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_expression_row.ExpressionRow, {
      canDelete: ruleParams.criteria && ruleParams.criteria.length > 1 || false,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_public2.RuleConditionChart, {
      metricExpression: {
        metrics: metricExpression,
        threshold: e.threshold,
        comparator: e.comparator,
        timeSize,
        timeUnit,
        warningComparator: e.warningComparator,
        warningThreshold: e.warningThreshold
      },
      searchConfiguration: {
        index: metricsView.dataViewReference.id,
        query: {
          query: ruleParams.filterQueryText || '',
          language: 'kuery'
        }
      },
      timeRange: {
        from: `now-${(timeSize !== null && timeSize !== void 0 ? timeSize : 1) * 20}${timeUnit}`,
        to: 'now'
      },
      error: errors[idx] || emptyError,
      dataView: metricsView.dataViewReference,
      groupBy: ruleParams.groupBy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginLeft: 28
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.expressions.addconditionButton.ariaLabel', {
      defaultMessage: 'Add condition'
    }),
    "data-test-subj": "infraExpressionsAddConditionButton",
    color: "primary",
    iconSide: "left",
    flush: "left",
    iconType: "plusInCircleFilled",
    onClick: addExpression,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.addCondition",
    defaultMessage: "Add condition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.filterLabel', {
      defaultMessage: 'Filter (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 7
    }
  }, metadata && /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    onQuerySubmit: onFilterChange,
    useDefaultBehaviors: false,
    query: {
      query: ruleParams.filterQueryText || '',
      language: 'kuery'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 11
    }
  }) || /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraExpressionsFieldSearch",
    onChange: handleFieldSearchChange,
    value: ruleParams.filterQueryText,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_group_by.MetricsExplorerGroupBy, {
    onChange: onGroupByChange,
    options: {
      ...options,
      groupBy: ruleParams.groupBy || undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 477,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "noDataBehavior",
    legend: {
      children: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 491,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.noDataBehaviorLabel', {
        defaultMessage: 'If there is no data'
      }))
    },
    options: getNoDataBehaviorOptions(hasGroupBy),
    idSelected: getNoDataBehaviorValue(ruleParams, hasGroupBy),
    onChange: id => {
      setRuleParams('noDataBehavior', id);
    },
    "data-test-subj": "metrics-alert-no-data-behavior",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 9
    }
  })));
};

// required for dynamic import
// eslint-disable-next-line import/no-default-export
exports.Expressions = Expressions;
var _default = exports.default = (0, _metrics_source.withSourceProvider)(Expressions)('default');