"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRequestRT = exports.SnapshotNodeResponseRT = exports.SnapshotNodeRT = exports.SnapshotNodePathRT = exports.SnapshotNodeMetricRT = exports.SnapshotNamedMetricInputRT = exports.SnapshotMetricInputRT = exports.SnapshotGroupByRT = exports.SnapshotCustomMetricInputRT = exports.SnapshotCustomAggregationRT = exports.SNAPSHOT_CUSTOM_AGGREGATIONS = exports.InfraTimerangeInputRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _data_schema_format = require("./shared/data_schema_format");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotNodePathRT = exports.SnapshotNodePathRT = rt.intersection([rt.type({
  value: rt.string,
  label: rt.string
}), rt.partial({
  ip: rt.union([rt.string, rt.null]),
  os: rt.union([rt.string, rt.null]),
  cloudProvider: rt.union([rt.string, rt.null])
})]);
const SnapshotNodeMetricOptionalRT = rt.partial({
  value: rt.union([rt.number, rt.null]),
  avg: rt.union([rt.number, rt.null]),
  max: rt.union([rt.number, rt.null]),
  timeseries: _common.MetricsAPISeriesRT
});
const SnapshotNodeMetricRequiredRT = rt.type({
  name: rt.union([_common.SnapshotMetricTypeRT, rt.string])
});
const SnapshotNodeMetricRT = exports.SnapshotNodeMetricRT = rt.intersection([SnapshotNodeMetricRequiredRT, SnapshotNodeMetricOptionalRT]);
const SnapshotNodeRT = exports.SnapshotNodeRT = rt.type({
  metrics: rt.array(SnapshotNodeMetricRT),
  path: rt.array(SnapshotNodePathRT),
  name: rt.string
});
const SnapshotNodeResponseRT = exports.SnapshotNodeResponseRT = rt.intersection([rt.type({
  nodes: rt.array(SnapshotNodeRT)
}), rt.partial({
  interval: rt.string
})]);
const InfraTimerangeInputRT = exports.InfraTimerangeInputRT = rt.intersection([rt.type({
  interval: rt.string,
  to: rt.number,
  from: rt.number
}), rt.partial({
  lookbackSize: rt.number,
  ignoreLookback: rt.boolean,
  forceInterval: rt.boolean
})]);
const SnapshotGroupByRT = exports.SnapshotGroupByRT = rt.array(rt.partial({
  label: rt.union([rt.string, rt.null]),
  field: rt.union([rt.string, rt.null])
}));
const SnapshotNamedMetricInputRT = exports.SnapshotNamedMetricInputRT = rt.type({
  type: _common.SnapshotMetricTypeRT
});
const SNAPSHOT_CUSTOM_AGGREGATIONS = exports.SNAPSHOT_CUSTOM_AGGREGATIONS = ['avg', 'max', 'min', 'rate', 'last_value'];
const snapshotCustomAggregationKeys = SNAPSHOT_CUSTOM_AGGREGATIONS.reduce((acc, agg) => ({
  ...acc,
  [agg]: null
}), {});
const SnapshotCustomAggregationRT = exports.SnapshotCustomAggregationRT = rt.keyof(snapshotCustomAggregationKeys);
const SnapshotCustomMetricInputRT = exports.SnapshotCustomMetricInputRT = rt.intersection([rt.type({
  type: rt.literal('custom'),
  field: rt.string,
  aggregation: SnapshotCustomAggregationRT,
  id: rt.string
}), rt.partial({
  label: rt.string
})]);
const SnapshotMetricInputRT = exports.SnapshotMetricInputRT = rt.union([SnapshotNamedMetricInputRT, SnapshotCustomMetricInputRT]);
const SnapshotRequestRT = exports.SnapshotRequestRT = rt.intersection([rt.type({
  timerange: InfraTimerangeInputRT,
  metrics: rt.array(SnapshotMetricInputRT),
  groupBy: rt.union([SnapshotGroupByRT, rt.null]),
  nodeType: _common.ItemTypeRT,
  sourceId: rt.string
}), rt.partial({
  includeTimeseries: rt.union([rt.boolean, (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(false)]),
  accountId: rt.string,
  region: rt.string,
  kuery: rt.string,
  overrideCompositeSize: rt.number,
  dropPartialBuckets: rt.boolean,
  schema: _data_schema_format.DataSchemaFormatRT
})]);