"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortRT = exports.paginationRT = exports.paginationCursorRT = exports.metricRT = exports.anomalyTypeRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// [Sort field value, tiebreaker value]
const paginationCursorRT = exports.paginationCursorRT = rt.tuple([rt.union([rt.string, rt.number]), rt.union([rt.string, rt.number])]);
const anomalyTypeRT = exports.anomalyTypeRT = rt.keyof({
  metrics_hosts: null,
  metrics_k8s: null
});
const sortOptionsRT = rt.keyof({
  anomalyScore: null,
  dataset: null,
  startTime: null
});
const sortDirectionsRT = rt.keyof({
  asc: null,
  desc: null
});
const paginationPreviousPageCursorRT = rt.type({
  searchBefore: paginationCursorRT
});
const paginationNextPageCursorRT = rt.type({
  searchAfter: paginationCursorRT
});
const paginationRT = exports.paginationRT = rt.intersection([rt.type({
  pageSize: rt.number
}), rt.partial({
  cursor: rt.union([paginationPreviousPageCursorRT, paginationNextPageCursorRT])
})]);
const sortRT = exports.sortRT = rt.type({
  field: sortOptionsRT,
  direction: sortDirectionsRT
});
const metricRT = exports.metricRT = rt.keyof({
  memory_usage: null,
  network_in: null,
  network_out: null
});