"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenAttributes = flattenAttributes;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function flattenAttributes(obj, parentKey = '') {
  const result = {};
  for (const key in obj) {
    if (Object.hasOwn(obj, key)) {
      const value = obj[key];
      const newKey = parentKey ? `${parentKey}.${key}` : key;
      if ((0, _lodash.isPlainObject)(value) || (0, _lodash.isArray)(value)) {
        Object.assign(result, flattenAttributes(value, newKey));
      } else {
        result[newKey] = value;
      }
    }
  }
  return result;
}