"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlDocumentBase = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _load_data = require("./load_data");
var _aliases = require("./aliases");
var _suggestions = require("./suggestions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadDataOnce = (0, _lodash.once)(_load_data.loadData);
class EsqlDocumentBase {
  static async load() {
    const data = await loadDataOnce();
    return new EsqlDocumentBase(data);
  }
  constructor(rawData) {
    (0, _defineProperty2.default)(this, "prompts", void 0);
    (0, _defineProperty2.default)(this, "docRecords", void 0);
    this.prompts = rawData.prompts;
    this.docRecords = rawData.docs;
  }
  getPrompts() {
    return this.prompts;
  }

  /** @deprecated use individual prompts instead */
  getSystemMessage() {
    return `${this.prompts.syntax}

    ${this.prompts.examples}
    `;
  }
  getDocumentation(rawKeywords, {
    generateMissingKeywordDoc = true,
    addSuggestions = true,
    resolveAliases = true
  } = {}) {
    const keywords = rawKeywords.map(raw => {
      let keyword = format(raw);
      if (resolveAliases) {
        keyword = (0, _aliases.tryResolveAlias)(keyword);
      }
      return keyword;
    });
    if (addSuggestions) {
      keywords.push(...(0, _suggestions.getSuggestions)(keywords));
    }
    return [...new Set(keywords)].reduce((results, keyword) => {
      if (Object.hasOwn(this.docRecords, keyword)) {
        results[keyword] = this.docRecords[keyword].data;
      } else if (generateMissingKeywordDoc) {
        results[keyword] = createDocForUnknownKeyword(keyword);
      }
      return results;
    }, {});
  }
}
exports.EsqlDocumentBase = EsqlDocumentBase;
const format = keyword => {
  return keyword.replaceAll(' ', '').toUpperCase();
};
const createDocForUnknownKeyword = keyword => {
  return `
  ## ${keyword}

  There is no ${keyword} function or command in ES|QL. Do NOT use it.
  `;
};