"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCallbackManager = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCallbackManager = cbs => {
  const callbacks = {
    complete: [],
    error: []
  };
  if (cbs !== null && cbs !== void 0 && cbs.complete) {
    callbacks.complete.push(...((0, _lodash.isArray)(cbs.complete) ? cbs.complete : [cbs.complete]));
  }
  if (cbs !== null && cbs !== void 0 && cbs.error) {
    callbacks.error.push(...((0, _lodash.isArray)(cbs.error) ? cbs.error : [cbs.error]));
  }
  const asEventEmitter = () => {
    return {
      on(type, handler) {
        if (type === 'complete') {
          callbacks.complete.push(handler);
        }
        if (type === 'error') {
          callbacks.error.push(handler);
        }
      }
    };
  };
  return {
    onComplete: event => {
      callbacks.complete.forEach(cb => {
        cb(event);
      });
    },
    onError: event => {
      callbacks.error.forEach(cb => {
        cb(event);
      });
    },
    asEventEmitter
  };
};
exports.createCallbackManager = createCallbackManager;