"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  workers: _configSchema.schema.object({
    anonymization: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      }),
      minThreads: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      }),
      maxThreads: _configSchema.schema.number({
        defaultValue: 3,
        min: 1
      }),
      maxQueue: _configSchema.schema.number({
        defaultValue: 20,
        min: 1
      }),
      idleTimeout: _configSchema.schema.duration({
        defaultValue: '30s'
      }),
      taskTimeout: _configSchema.schema.duration({
        defaultValue: '15s'
      })
    })
  })
});