"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteApi = createChatCompleteApi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteApi({
  callbackApi
}) {
  return options => {
    const {
      connectorId,
      stream,
      abortSignal,
      retryConfiguration,
      maxRetries,
      ...rest
    } = options;
    return callbackApi({
      connectorId,
      stream,
      abortSignal,
      retryConfiguration,
      maxRetries
    }, () => {
      return rest;
    });
  };
}