"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyProviderTransforms = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _convert_tools = require("../../bedrock/convert_tools");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applyProviderTransforms = options => {
  let provider = (0, _utils.getProvider)(options.connector);
  if (provider === _inferenceCommon.InferenceEndpointProvider.Elastic) {
    // retrieve the underlying provider used by elastic
    provider = (0, _utils.getElasticModelProvider)(options.connector);
  }
  if (provider === _inferenceCommon.InferenceEndpointProvider.AmazonBedrock) {
    options = applyBedrockTransforms(options);
  }
  return options;
};
exports.applyProviderTransforms = applyProviderTransforms;
const applyBedrockTransforms = options => {
  var _options$tools;
  if (options.tools) {
    options.tools = Object.entries(options.tools).reduce((tools, [toolName, toolDef]) => {
      tools[toolName] = {
        ...toolDef,
        schema: toolDef.schema ? (0, _convert_tools.fixSchemaArrayProperties)(toolDef.schema) : undefined
      };
      return tools;
    }, {});
  }
  const hasToolUse = options.messages.some(message => {
    var _message$toolCalls;
    return message.role === _inferenceCommon.MessageRole.Tool || message.role === _inferenceCommon.MessageRole.Assistant && ((_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.length);
  });

  // bedrock does not accept tool calls in conversation history
  // if no tools are present in the request.
  if (hasToolUse && Object.keys((_options$tools = options.tools) !== null && _options$tools !== void 0 ? _options$tools : {}).length === 0) {
    options.tools = {
      doNotCallThisTool: {
        description: 'Do not call this tool, it is strictly forbidden',
        schema: {
          type: 'object',
          properties: {}
        }
      }
    };
  }
  return options;
};