"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBucketFunctionNode = isBucketFunctionNode;
exports.isColumnNode = isColumnNode;
exports.isDateTruncFunctionNode = isDateTruncFunctionNode;
exports.isFunctionNode = isFunctionNode;
exports.isLikeOperatorNode = isLikeOperatorNode;
exports.isLiteralNode = isLiteralNode;
exports.isSingleItem = isSingleItem;
exports.isStringLiteralNode = isStringLiteralNode;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isSingleItem(item) {
  return Object.hasOwn(item, 'type');
}
function isFunctionNode(node) {
  return isSingleItem(node) && node.type === 'function';
}
function isColumnNode(node) {
  return isSingleItem(node) && node.type === 'column';
}
function isLiteralNode(node) {
  return isSingleItem(node) && node.type === 'literal';
}
function isStringLiteralNode(node) {
  return isLiteralNode(node) && node.literalType === 'keyword';
}
function isDateTruncFunctionNode(node) {
  return isFunctionNode(node) && node.subtype === 'variadic-call' && node.name === 'date_trunc';
}
function isBucketFunctionNode(node) {
  return isFunctionNode(node) && node.subtype === 'variadic-call' && node.name === 'bucket';
}
function isLikeOperatorNode(node) {
  return isFunctionNode(node) && node.subtype === 'binary-expression' && node.name === 'like';
}