"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSimulateRoute = registerSimulateRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
function registerSimulateRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.post({
    path: (0, _.addBasePath)('/index_templates/simulate/{templateName?}'),
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: {
      body: _configSchema.schema.nullable(bodySchema),
      params: _configSchema.schema.object({
        templateName: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const template = request.body;
    // Until ES fixes a bug on their side we need to send a fake index pattern
    // that won't match any indices.
    // Issue: https://github.com/elastic/elasticsearch/issues/59152
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const index_patterns = ['a_fake_index_pattern_that_wont_match_any_indices'];
    const templateName = request.params.templateName;
    const params = templateName ? {
      name: templateName
    } : {
      ...template,
      index_patterns
    };
    try {
      var _persistent$cluster$l, _persistent$cluster, _persistent$cluster$l2, _defaults$cluster, _defaults$cluster$log;
      const templatePromise = client.asCurrentUser.indices.getIndexTemplate({
        name: templateName
      });
      const templatePreviewPromise = client.asCurrentUser.indices.simulateTemplate(params);
      const settingsPromise = client.asInternalUser.cluster.getSettings({
        include_defaults: true
      });
      const [templateContent, templatePreview, {
        persistent,
        defaults
      }] = await Promise.all([templatePromise, templatePreviewPromise, settingsPromise]);
      const isLogsPattern = !!templateContent.index_templates.find(t => {
        var _t$index_template$ind;
        return (// @ts-expect-error I think there are some incorrect types from the es client package
          (_t$index_template$ind = t.index_template.index_patterns) === null || _t$index_template$ind === void 0 ? void 0 : _t$index_template$ind.some(pattern => pattern === 'logs-*-*')
        );
      });
      const isLogsdbEnabled = ((_persistent$cluster$l = persistent === null || persistent === void 0 ? void 0 : (_persistent$cluster = persistent.cluster) === null || _persistent$cluster === void 0 ? void 0 : (_persistent$cluster$l2 = _persistent$cluster.logsdb) === null || _persistent$cluster$l2 === void 0 ? void 0 : _persistent$cluster$l2.enabled) !== null && _persistent$cluster$l !== void 0 ? _persistent$cluster$l : defaults === null || defaults === void 0 ? void 0 : (_defaults$cluster = defaults.cluster) === null || _defaults$cluster === void 0 ? void 0 : (_defaults$cluster$log = _defaults$cluster.logsdb) === null || _defaults$cluster$log === void 0 ? void 0 : _defaults$cluster$log.enabled) === 'true';
      templatePreview.template.settings.index = templatePreview.template.settings.index || {};
      templatePreview.template.settings.index.mode = templatePreview.template.settings.index.mode || (isLogsdbEnabled && isLogsPattern ? 'logsdb' : 'standard');
      return response.ok({
        body: templatePreview
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}