"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../../app_context");
var _lib = require("../../../../../../../common/lib");
var _data_streams = require("../../../../../lib/data_streams");
var _constants = require("../../../../../constants");
var _use_ilm_locator = require("../../../../../services/use_ilm_locator");
var _use_ingest_pipeline_locator = require("../../../../../services/use_ingest_pipeline_locator");
var _constants2 = require("../../../../../../../common/constants");
var _index_mode_labels = require("../../../../../lib/index_mode_labels");
var _ = require("../../../../../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/template_details/tabs/tab_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INFINITE_AS_ICON = true;
const i18nTexts = {
  yes: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.yesDescriptionText', {
    defaultMessage: 'Yes'
  }),
  no: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noDescriptionText', {
    defaultMessage: 'No'
  }),
  none: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noneDescriptionText', {
    defaultMessage: 'None'
  })
};
const TabSummary = ({
  templateDetails
}) => {
  var _templateDetails$temp, _templateDetails$temp2, _templateDetails$temp3;
  const {
    version,
    priority,
    composedOf,
    order,
    indexPatterns = [],
    indexMode,
    ilmPolicy,
    _meta,
    _kbnMeta: {
      isLegacy,
      hasDatastream
    },
    allowAutoCreate
  } = templateDetails;
  const numIndexPatterns = indexPatterns.length;
  const {
    core,
    url
  } = (0, _app_context.useAppContext)();
  const ilmPolicyLink = (0, _use_ilm_locator.useIlmLocator)(_constants.ILM_PAGES_POLICY_EDIT, ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name);
  const locator = url.locators.get(_.INDEX_MANAGEMENT_LOCATOR_ID);

  // Compute the linked ingest pipeline URL
  const linkedIngestPipeline = templateDetails === null || templateDetails === void 0 ? void 0 : (_templateDetails$temp = templateDetails.template) === null || _templateDetails$temp === void 0 ? void 0 : (_templateDetails$temp2 = _templateDetails$temp.settings) === null || _templateDetails$temp2 === void 0 ? void 0 : (_templateDetails$temp3 = _templateDetails$temp2.index) === null || _templateDetails$temp3 === void 0 ? void 0 : _templateDetails$temp3.default_pipeline;
  const linkedIngestPipelineUrl = (0, _use_ingest_pipeline_locator.useIngestPipelinesLocator)(_constants.INGEST_PIPELINES_EDIT, linkedIngestPipeline);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "summaryTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.indexPatternsDescriptionListTitle",
    defaultMessage: "Index {numIndexPatterns, plural, one {pattern} other {patterns}}",
    values: {
      numIndexPatterns
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, numIndexPatterns > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }, indexPatterns.map((indexName, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${indexName}-${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 29
      }
    }, indexName)));
  }))) : indexPatterns.toString()), isLegacy !== true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.priorityDescriptionListTitle",
    defaultMessage: "Priority",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }, priority || priority === 0 ? priority : i18nTexts.none)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.orderDescriptionListTitle",
    defaultMessage: "Order",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, order || order === 0 ? order : i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "componentsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.componentsDescriptionListTitle",
    defaultMessage: "Component templates",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }, composedOf && composedOf.length > 0 ? /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }, composedOf.map(component => /*#__PURE__*/_react.default.createElement("li", {
    key: component,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
      page: 'component_template',
      componentTemplate: component
    })) || '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 29
    }
  }, component))))) : i18nTexts.none)), linkedIngestPipeline && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.linkedIngestPipelineDescriptionListTitle",
    defaultMessage: "Default pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => core.application.navigateToUrl(linkedIngestPipelineUrl),
    "data-test-subj": "linkedIngestPipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 19
    }
  }, linkedIngestPipeline))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.ilmPolicyDescriptionListTitle",
    defaultMessage: "ILM policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, ilmPolicy !== null && ilmPolicy !== void 0 && ilmPolicy.name && ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => core.application.navigateToUrl(ilmPolicyLink),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 21
    }
  }, ilmPolicy.name) : (ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name) || i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.dataStreamDescriptionListTitle",
    defaultMessage: "Data stream",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 17
    }
  }, hasDatastream ? i18nTexts.yes : i18nTexts.no)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.versionDescriptionListTitle",
    defaultMessage: "Version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, version || version === 0 ? version : i18nTexts.none), hasDatastream && (templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails.lifecycle) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.lifecycleDescriptionListTitle",
    defaultMessage: "Data retention",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 17
    }
  }, (0, _data_streams.getLifecycleValue)((0, _lib.serializeAsESLifecycle)(templateDetails.lifecycle), INFINITE_AS_ICON))), indexMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.stepReview.summaryTab.indexModeLabel",
    defaultMessage: "Index mode",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "indexModeValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 17
    }
  }, _index_mode_labels.indexModeLabels[indexMode])), isLegacy !== true && allowAutoCreate !== _constants2.allowAutoCreateRadioIds.NO_OVERWRITE_RADIO_OPTION && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.allowAutoCreateDescriptionListTitle",
    defaultMessage: "Allow auto create",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 19
    }
  }, allowAutoCreate === _constants2.allowAutoCreateRadioIds.TRUE_RADIO_OPTION ? i18nTexts.yes : i18nTexts.no))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }, isLegacy !== true && _meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.metaDescriptionListTitle",
    defaultMessage: "Metadata",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 15
    }
  }, JSON.stringify(_meta, null, 2))))));
};
exports.TabSummary = TabSummary;