"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoShapeType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/field_types/geo_shape_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultToggleValue = (param, field) => {
  const {
    defaultValue
  } = (0, _lib.getFieldConfig)(param);
  switch (param) {
    // Switches that don't map to a boolean in the mappings
    case 'orientation':
      {
        return field[param] !== undefined && field[param] !== defaultValue;
      }
    default:
      // All "boolean" parameters
      return field[param] !== undefined ? field[param] // If the field has a value set, use it
      : defaultValue !== undefined // If the parameter definition has a "defaultValue" set, use it
      ? defaultValue : false;
    // Defaults to "false"
  }
};
const GeoShapeType = ({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreMalformedParameter, {
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShape.ignoreMalformedFieldDescription', {
      defaultMessage: 'By default, documents that contain malformed GeoJSON or WKT shapes are not indexed. If enabled, these documents are indexed, but fields with malformed shapes are filtered out. Be careful: if too many documents are indexed this way, queries on the field become meaningless.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.OrientationParameter, {
    defaultToggleValue: getDefaultToggleValue('orientation', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShape.pointsOnlyFieldTitle', {
      defaultMessage: 'Points only'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShape.pointsOnlyFieldDescription', {
      defaultMessage: 'Optimizes geo-shape queries if this field contains only geo-points. Shapes, including multi-point shapes, will be rejected.'
    }),
    formFieldPath: "points_only",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreZValueParameter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.CoerceShapeParameter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })));
};
exports.GeoShapeType = GeoShapeType;