"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateButtonPopOver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/components/create_button_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateButtonPopOver = ({
  anchorPosition = 'upCenter'
}) => {
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "createComponentTemplatePanel",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "manageTemplateButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsPopOverOpen(prev => !prev),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplatesFlyout.manageButtonLabel",
      defaultMessage: "Create",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 11
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: anchorPosition,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createContextMenuPanelTitle', {
        defaultMessage: 'New component template'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createComponentTemplateFromScratchButtonLabel', {
          defaultMessage: 'From scratch'
        }),
        icon: 'plusInCircle',
        onClick: () => {
          // console.log('Create component template...');
        }
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesFlyout.createComponentTemplateFromExistingButtonLabel', {
          defaultMessage: 'From existing index template'
        }),
        icon: 'symlink',
        onClick: () => {
          // console.log('Create component template from index template...');
        }
      }]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
exports.CreateButtonPopOver = CreateButtonPopOver;