"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PublicApiService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Index Lifecycle Management public API service
 */
class PublicApiService {
  /**
   * constructor
   * @param http http dependency
   */
  constructor(http) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }

  /**
   * Fetches all ILM policies available in Index Lifecycle Management.
   */
  getPolicies(options) {
    return this.http.get(`${_constants.API_BASE_PATH}/policies`, {
      signal: options === null || options === void 0 ? void 0 : options.signal
    });
  }
}
exports.PublicApiService = PublicApiService;