"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Build the breadcrumbs for this app
const breadcrumbs = function () {
  const policies = [{
    text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.breadcrumb.homeLabel', {
      defaultMessage: 'Index Lifecycle Management'
    }),
    href: `/policies`
  }];
  const editPolicy = [...policies, {
    text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.breadcrumb.editPolicyLabel', {
      defaultMessage: 'Edit policy'
    }),
    href: undefined
  }];
  return {
    policies,
    editPolicy
  };
}();
class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = breadcrumbs[type] ? [...breadcrumbs[type]] : [...breadcrumbs.policies];

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
exports.BreadcrumbService = BreadcrumbService;