"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageData = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _app_navigation_handler = require("../app_navigation_handler");
var _synopsis = require("../synopsis");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/manage_data/manage_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ManageData = ({
  addBasePath,
  application,
  features
}) => {
  var _share$url$locators$g, _share$url$locators$g2;
  const {
    share,
    trackUiMetric
  } = (0, _kibana_services.getServices)();
  const consoleHref = (_share$url$locators$g = share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const managementHref = (_share$url$locators$g2 = share.url.locators.get('MANAGEMENT_APP_LOCATOR')) === null || _share$url$locators$g2 === void 0 ? void 0 : _share$url$locators$g2.useUrl({
    sectionId: ''
  });
  if (features.length) {
    const {
      management: isManagementEnabled,
      dev_tools: isDevToolsEnabled
    } = application.capabilities.navLinks;
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      "aria-labelledby": "homeDataManage__title",
      "data-test-subj": "homeDataManage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homeDataManage__title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.sectionTitle",
      defaultMessage: "Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 17
      }
    })))), isDevToolsEnabled || isManagementEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 15
      }
    }, isDevToolsEnabled && consoleHref !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "homeDevTools",
      flush: "both",
      iconType: "wrench",
      href: consoleHref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.devToolsButtonLabel",
      defaultMessage: "Dev Tools",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 23
      }
    }))) : null, isManagementEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "homeManage",
      flush: "both",
      iconType: "gear",
      href: managementHref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.stackManagementButtonLabel",
      defaultMessage: "Stack Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 23
      }
    }))) : null)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, features.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: ({
        euiTheme
      }) => (0, _react2.css)({
        [`@media (min-width: ${euiTheme.breakpoint.l}px)`]: {
          maxWidth: `calc(33.33% - ${euiTheme.size.l})`
        }
      }),
      key: feature.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
      description: feature.description,
      iconType: feature.icon,
      id: feature.id,
      onClick: event => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `manage_data_card_${feature.id}`);
        (0, _app_navigation_handler.createAppNavigationHandler)(feature.path)(event);
      },
      title: feature.title,
      url: addBasePath(feature.path),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    })))));
  } else {
    return null;
  }
};
exports.ManageData = ManageData;