"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokdebuggerService = void 0;
var _constants = require("../../../common/constants");
var _grokdebugger_response = require("../../models/grokdebugger_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GrokdebuggerService {
  constructor(http) {
    this.http = http;
  }
  simulate(grokdebuggerRequest) {
    return this.http.post(`${_constants.ROUTES.API_ROOT}/simulate`, {
      body: JSON.stringify(grokdebuggerRequest.upstreamJSON)
    }).then(response => {
      return _grokdebugger_response.GrokdebuggerResponse.fromUpstreamJSON(response);
    }).catch(e => {
      throw new Error(e.body.message);
    });
  }
}
exports.GrokdebuggerService = GrokdebuggerService;