"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcePicker = SourcePicker;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/source_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fixedPageSize = 8;
function SourcePicker({
  contentManagement,
  onIndexPatternSelected,
  uiSettings
}) {
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "graphSourcePicker",
    services: {
      contentClient: contentManagement.client,
      uiSettings
    },
    onChoose: (_id, _type, _name, indexPattern) => {
      onIndexPatternSelected(indexPattern);
    },
    showFilter: false,
    noItemsMessage: _i18n.i18n.translate('xpack.graph.sourceModal.notFoundLabel', {
      defaultMessage: 'No data sources found.'
    }),
    savedObjectMetaData: [{
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.graph.sourceModal.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      }),
      showSavedObject: indexPattern => !indexPattern.attributes.type,
      includeFields: ['type']
    }],
    fixedPageSize: fixedPageSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
}