"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalSearchBarPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _search_bar = require("./components/search_bar");
var _telemetry = require("./telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/global_search_bar/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class GlobalSearchBarPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup({
    analytics
  }) {
    _telemetry.eventTypes.forEach(eventType => {
      analytics.registerEventType(eventType);
    });
    return {};
  }
  start(core, startDeps) {
    core.chrome.navControls.registerCenter(this.getNavControl({
      core,
      ...startDeps
    }));
    return {};
  }
  getNavControl(deps) {
    const {
      core,
      globalSearch,
      savedObjectsTagging,
      usageCollection
    } = deps;
    const {
      application,
      http
    } = core;
    const reportEvent = new _telemetry.EventReporter({
      analytics: core.analytics,
      usageCollection
    });
    const navControl = {
      order: 1000,
      mount: container => {
        _reactDom.default.render(core.rendering.addContext(/*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
          globalSearch: {
            ...globalSearch,
            searchCharLimit: this.config.input_max_limit
          },
          navigateToUrl: application.navigateToUrl,
          taggingApi: savedObjectsTagging,
          basePathUrl: http.basePath.prepend('/plugins/globalSearchBar/assets/'),
          chromeStyle$: core.chrome.getChromeStyle$(),
          reportEvent: reportEvent,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 13
          }
        })), container);
        return () => _reactDom.default.unmountComponentAtNode(container);
      }
    };
    return navControl;
  }
}
exports.GlobalSearchBarPlugin = GlobalSearchBarPlugin;