"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportSettings = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getExportSettings = async (client, taskInstanceFields, config, timezone, logger) => {
  var _moment$tz$zone$name, _moment$tz$zone;
  let setTimezone;
  if (timezone) {
    setTimezone = timezone;
  } else {
    // try to get the timezone from the settings
    setTimezone = await client.get(_constants.UI_SETTINGS_DATEFORMAT_TZ);
  }
  setTimezone = (_moment$tz$zone$name = (_moment$tz$zone = _moment.default.tz.zone(setTimezone)) === null || _moment$tz$zone === void 0 ? void 0 : _moment$tz$zone.name) !== null && _moment$tz$zone$name !== void 0 ? _moment$tz$zone$name : _moment.default.tz.guess(true);

  // Advanced Settings that affect search export + CSV
  const [includeFrozen, separator, quoteValues] = await Promise.all([client.get(_constants.UI_SETTINGS_SEARCH_INCLUDE_FROZEN), client.get(_constants.UI_SETTINGS_CSV_SEPARATOR), client.get(_constants.UI_SETTINGS_CSV_QUOTE_VALUES)]);
  const escapeFormulaValues = config.escapeFormulaValues;
  const escapeValue = (0, _common.createEscapeValue)({
    separator,
    quoteValues,
    escapeFormulaValues
  });
  const bom = config.useByteOrderMarkEncoding ? _constants.CSV_BOM_CHARS : '';
  return {
    timezone: setTimezone,
    taskInstanceFields,
    scroll: {
      strategy: config.scroll.strategy,
      size: config.scroll.size,
      duration: ({
        retryAt
      }, format = 'ms') => {
        if (config.scroll.duration !== 'auto') {
          return config.scroll.duration;
        }
        if (!retryAt) {
          throw new Error('config "xpack.reporting.csv.scroll.duration" of "auto" mandates that the task instance field passed specifies a retryAt value');
        }
        const now = new Date(Date.now()).getTime();
        const timeTillRetry = new Date(retryAt).getTime();
        if (now >= timeTillRetry) {
          return `0${format}`;
        }
        const _duration = timeTillRetry - now;
        const result = format === 'ms' ? `${_duration}ms` : `${_duration / 1000}s`;
        logger.debug(`using timeout duration of ${result} for csv scroll`);
        return result;
      }
    },
    bom,
    includeFrozen,
    separator,
    maxSizeBytes: config.maxSizeBytes,
    checkForFormulas: config.checkForFormulas,
    escapeFormulaValues,
    escapeValue,
    maxConcurrentShardRequests: config.maxConcurrentShardRequests,
    maxRows: config.maxRows
  };
};
exports.getExportSettings = getExportSettings;