"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiSettingsApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _spacesUtils = require("@kbn/spaces-utils");
var _lodash = require("lodash");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _telemetry = require("@kbn/onechat-common/telemetry");
var _enabled_features_context = require("../contexts/enabled_features_context");
var _use_kibana = require("../hooks/use_kibana");
var _go_to_spaces_button = require("./go_to_spaces_button");
var _use_genai_connectors = require("../hooks/use_genai_connectors");
var _get_elastic_managed_llm_connector = require("../utils/get_elastic_managed_llm_connector");
var _settings_context = require("../contexts/settings_context");
var _default_ai_connector = require("./default_ai_connector/default_ai_connector");
var _bottom_bar_actions = require("./bottom_bar_actions/bottom_bar_actions");
var _ai_assistant_visibility = require("./ai_assistant_visibility/ai_assistant_visibility");
var _chat_experience = require("./chat_experience/chat_experience");
var _documentation = require("./documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/gen_ai_settings_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TELEMETRY_SOURCE = 'stack_management';
const isAIChatExperience = value => typeof value === 'string' && (value === _aiAssistantCommon.AIChatExperience.Classic || value === _aiAssistantCommon.AIChatExperience.Agent);
const GenAiSettingsApp = ({
  setBreadcrumbs
}) => {
  var _ref, _ref2, _unsavedChanges$AI_CH, _unsavedChanges$AI_CH2, _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4, _application$capabili5;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application,
    http,
    docLinks,
    productDocBase,
    analytics
  } = services;
  const {
    showSpacesIntegration,
    isPermissionsBased,
    showAiBreadcrumb,
    showAiAssistantsVisibilitySetting,
    showChatExperienceSetting
  } = (0, _enabled_features_context.useEnabledFeatures)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fields,
    unsavedChanges,
    isSaving,
    cleanUnsavedChanges,
    saveAll
  } = (0, _settings_context.useSettingsContext)();

  // Determine current chat experience (including unsaved changes)
  const chatExperienceField = fields[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE];
  const currentChatExperience = (_ref = (_ref2 = (_unsavedChanges$AI_CH = (_unsavedChanges$AI_CH2 = unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE]) === null || _unsavedChanges$AI_CH2 === void 0 ? void 0 : _unsavedChanges$AI_CH2.unsavedValue) !== null && _unsavedChanges$AI_CH !== void 0 ? _unsavedChanges$AI_CH : chatExperienceField === null || chatExperienceField === void 0 ? void 0 : chatExperienceField.savedValue) !== null && _ref2 !== void 0 ? _ref2 : chatExperienceField === null || chatExperienceField === void 0 ? void 0 : chatExperienceField.defaultValue) !== null && _ref !== void 0 ? _ref : _aiAssistantCommon.AIChatExperience.Classic;
  const isAgentExperience = currentChatExperience === _aiAssistantCommon.AIChatExperience.Agent;
  const hasAgentBuilderPrivileges = ((_application$capabili = application.capabilities.agentBuilder) === null || _application$capabili === void 0 ? void 0 : _application$capabili.manageAgents) === true;
  const hasConnectorsAllPrivilege = ((_application$capabili2 = application.capabilities.actions) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show) === true && ((_application$capabili3 = application.capabilities.actions) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.execute) === true && ((_application$capabili4 = application.capabilities.actions) === null || _application$capabili4 === void 0 ? void 0 : _application$capabili4.delete) === true && ((_application$capabili5 = application.capabilities.actions) === null || _application$capabili5 === void 0 ? void 0 : _application$capabili5.save) === true;
  const canManageSpaces = application.capabilities.management.kibana.spaces;
  const connectors = (0, _use_genai_connectors.useGenAiConnectors)();
  const hasElasticManagedLlm = (0, _get_elastic_managed_llm_connector.getElasticManagedLlmConnector)(connectors.connectors);
  (0, _react.useEffect)(() => {
    const breadcrumbs = [...(showAiBreadcrumb ? [{
      text: _i18n.i18n.translate('genAiSettings.breadcrumbs.ai', {
        defaultMessage: 'AI'
      })
    }] : []), {
      text: _i18n.i18n.translate('genAiSettings.breadcrumbs.genAiSettings', {
        defaultMessage: 'GenAI Settings'
      })
    }];
    setBreadcrumbs(breadcrumbs);
  }, [setBreadcrumbs, showAiBreadcrumb]);
  const handleNavigateToSpaces = (0, _react.useCallback)(() => {
    const basePath = http.basePath.get();
    const {
      spaceId
    } = (0, _spacesUtils.getSpaceIdFromPath)(basePath, http.basePath.serverBasePath);
    const spacesPath = `/kibana/spaces/edit/${spaceId}${isPermissionsBased ? '/roles' : ''}`;
    application.navigateToApp('management', {
      path: spacesPath,
      openInNewTab: true
    });
  }, [application, http.basePath, isPermissionsBased]);
  const connectorDescription = (0, _react.useMemo)(() => {
    var _docLinks$links2, _docLinks$links2$obse;
    if (!hasElasticManagedLlm) {
      var _docLinks$links, _docLinks$links$obser;
      return /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "genAiSettings.aiConnectorDescription",
        defaultMessage: `AI-powered features require a large language model (LLM) connector. You can use the Elastic Managed LLM ({atAdditionalCost}) or configure a third-party connector.
              When you set a default AI connector, it is pre-selected for all of these features in this space.
              If you haven't set a default, the most recently used connector is selected automatically. {manageConnectors}`,
        values: {
          manageConnectors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: application.getUrlForApp('management', {
              path: 'insightsAndAlerting/triggersActionsConnectors/connectors'
            }),
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 128,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "genAiSettings.manage.connectors",
            defaultMessage: hasConnectorsAllPrivilege ? 'Manage connectors' : 'View connectors',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 134,
              columnNumber: 19
            }
          })),
          atAdditionalCost: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 143,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "genAiSettings.additionalCostLink",
            defaultMessage: "at additional cost",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 147,
              columnNumber: 19
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 11
        }
      }));
    }
    const showSpacesNote = showSpacesIntegration && canManageSpaces && hasConnectorsAllPrivilege;
    return /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiConnectorDescriptionWithLink",
      defaultMessage: `A large language model (LLM) is required to power the AI Assistant and AI-powered features. By default, Elastic uses its {elasticManagedLlm} connector ({link}) when no custom connectors are available. When available, Elastic uses the last used custom connector.${showSpacesNote ? ' Set up your own connectors or disable the AI Assistant from the {aiFeatureVisibility} setting below.' : ''} {manageConnectors}`,
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links2 = docLinks.links) === null || _docLinks$links2 === void 0 ? void 0 : (_docLinks$links2$obse = _docLinks$links2.observability) === null || _docLinks$links2$obse === void 0 ? void 0 : _docLinks$links2$obse.elasticManagedLlmUsageCost,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 172,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.additionalCostsLink",
          defaultMessage: "additional costs incur",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 176,
            columnNumber: 17
          }
        })),
        manageConnectors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application.getUrlForApp('management', {
            path: 'insightsAndAlerting/triggersActionsConnectors/connectors'
          }),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.manage.connectors",
          defaultMessage: "Manage connectors",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 17
          }
        })),
        elasticManagedLlm: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.elasticManagedLlm",
          defaultMessage: "Elastic Managed LLM",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 17
          }
        })),
        ...(showSpacesNote && {
          aiFeatureVisibility: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 205,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "genAiSettings.aiFeatureVisibilityText",
            defaultMessage: "AI feature visibility",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 206,
              columnNumber: 19
            }
          }))
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }));
  }, [hasElasticManagedLlm, hasConnectorsAllPrivilege, showSpacesIntegration, canManageSpaces, docLinks, application]);
  async function handleSave() {
    var _unsavedChanges$AI_CH3, _unsavedChanges$AI_CH4, _ref3;
    const savedChatExperience = isAIChatExperience(chatExperienceField === null || chatExperienceField === void 0 ? void 0 : chatExperienceField.savedValue) ? chatExperienceField.savedValue : undefined;
    const defaultChatExperience = isAIChatExperience(chatExperienceField === null || chatExperienceField === void 0 ? void 0 : chatExperienceField.defaultValue) ? chatExperienceField.defaultValue : undefined;
    const unsavedChatExperience = isAIChatExperience((_unsavedChanges$AI_CH3 = unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE]) === null || _unsavedChanges$AI_CH3 === void 0 ? void 0 : _unsavedChanges$AI_CH3.unsavedValue) ? (_unsavedChanges$AI_CH4 = unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE]) === null || _unsavedChanges$AI_CH4 === void 0 ? void 0 : _unsavedChanges$AI_CH4.unsavedValue : undefined;
    const normalizedSavedChatExperience = savedChatExperience !== null && savedChatExperience !== void 0 ? savedChatExperience : _aiAssistantCommon.AIChatExperience.Classic;

    // Telemetry should compare the effective "before" and "after" values.
    // - "before" should include the default if there is no saved value.
    // - "after" should reflect the unsaved change, or fall back to "before" if unchanged.
    const telemetryBeforeChatExperience = (_ref3 = savedChatExperience !== null && savedChatExperience !== void 0 ? savedChatExperience : defaultChatExperience) !== null && _ref3 !== void 0 ? _ref3 : _aiAssistantCommon.AIChatExperience.Classic;
    const telemetryAfterChatExperience = unsavedChatExperience !== null && unsavedChatExperience !== void 0 ? unsavedChatExperience : telemetryBeforeChatExperience;
    const shouldTrackOptInConfirmed = telemetryBeforeChatExperience !== _aiAssistantCommon.AIChatExperience.Agent && telemetryAfterChatExperience === _aiAssistantCommon.AIChatExperience.Agent;
    const shouldTrackOptOut = telemetryBeforeChatExperience === _aiAssistantCommon.AIChatExperience.Agent && telemetryAfterChatExperience !== _aiAssistantCommon.AIChatExperience.Agent;
    const needsReload = await saveAll();
    if (shouldTrackOptInConfirmed) {
      analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry.AGENT_BUILDER_EVENT_TYPES.OptInAction, {
        action: 'confirmed',
        source: TELEMETRY_SOURCE
      });
    }
    if (shouldTrackOptOut) {
      analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry.AGENT_BUILDER_EVENT_TYPES.OptOut, {
        source: TELEMETRY_SOURCE
      });
    }
    if (needsReload) {
      // Only skip `step_reached` after reload if it could have been reported on this page load.
      // This prevents suppressing the Agent -> Classic transition, where `step_reached` should be
      // emitted after reload.
      const shouldSkipStepReachedOnReload = normalizedSavedChatExperience === _aiAssistantCommon.AIChatExperience.Classic && !(savedChatExperience === undefined && defaultChatExperience === _aiAssistantCommon.AIChatExperience.Agent);
      if (shouldSkipStepReachedOnReload) {
        try {
          // We reload the page after saving; without this one-shot flag, `ChatExperience` would emit
          // `step_reached` both before and after the reload.
          window.sessionStorage.setItem('gen_ai_settings:skip_step_reached_once', `${Date.now()}`);
        } catch {
          // ignore
        }
      }
      window.location.reload();
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "genAiSettingsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "genAiSettingsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.genAiSettings.pageTitle",
    defaultMessage: "GenAI Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    css: {
      paddingTop: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "generalSectionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "genAiSettings.general.title",
    defaultMessage: "General",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    "data-test-subj": "connectorsSection",
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sparkles",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "connectorsTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiConnectorLabel",
      defaultMessage: "Default AI Connector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 27
      }
    }))))),
    description: connectorDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_default_ai_connector.DefaultAIConnector, {
    connectors: connectors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 23
    }
  }))))), showSpacesIntegration && canManageSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 60
    }
  }), showSpacesIntegration && canManageSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    "data-test-subj": "aiFeatureVisibilitySection",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "aiFeatureVisibilityTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiFeatureVisibilityLabel",
      defaultMessage: "AI feature visibility",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 23
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 21
      }
    }, isPermissionsBased ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.solutionViewDescriptionLabel",
      defaultMessage: "Turn AI-powered features on or off (for custom roles only) on the {permissionsTab} in the {spaces} settings. Create custom roles at {rolesLink}.",
      values: {
        permissionsTab: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 363,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.permissionsTab",
          defaultMessage: "Permissions tab",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 364,
            columnNumber: 33
          }
        })),
        spaces: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 371,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.spacesLabel",
          defaultMessage: "Spaces",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 372,
            columnNumber: 33
          }
        })),
        rolesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application.getUrlForApp('management', {
            path: '/security/roles'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 379,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.rolesLink",
          defaultMessage: "Stack Management > Roles",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 384,
            columnNumber: 33
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 25
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.showAIAssistantDescriptionLabel",
      defaultMessage: "You can enable or disable AI-powered features from the {space} settings page.",
      values: {
        space: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 398,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.spacesLabel",
          defaultMessage: "Space",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 399,
            columnNumber: 33
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 393,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_go_to_spaces_button.GoToSpacesButton, {
    onNavigateToSpaces: handleNavigateToSpaces,
    navigateToPermissions: isPermissionsBased,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 21
    }
  }))), showChatExperienceSetting && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_chat_experience.ChatExperience, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 19
    }
  })), showAiAssistantsVisibilitySetting && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_ai_assistant_visibility.AIAssistantVisibility, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 19
    }
  })))), isAgentExperience && (showChatExperienceSetting || hasAgentBuilderPrivileges) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_documentation.DocumentationSection, {
    productDocBase: productDocBase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 15
    }
  })))), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.gen_ai_settings.settings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    appTestSubj: "genAiSettingsSaveBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 9
    }
  }));
};
exports.GenAiSettingsApp = GenAiSettingsApp;