"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBulkDeleteRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerBulkDeleteRoute = router => {
  router.post({
    path: `${_utils.KBN_CLIENT_API_PREFIX}/_bulk_delete`,
    security: {
      authz: {
        requiredPrivileges: ['ftrApis']
      }
    },
    validate: {
      body: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      }))
    }
  }, (0, _utils.catchAndReturnBoomErrors)(async (ctx, req, res) => {
    const {
      savedObjects
    } = await ctx.core;
    const hiddenTypes = (0, _utils.listHiddenTypes)(savedObjects.typeRegistry);
    const soClient = savedObjects.getClient({
      includedHiddenTypes: hiddenTypes
    });
    const statuses = await soClient.bulkDelete(req.body, {
      force: true,
      refresh: true
    });
    return res.ok({
      body: statuses
    });
  }));
};
exports.registerBulkDeleteRoute = registerBulkDeleteRoute;