"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureFleetGlobalEsAssets = ensureFleetGlobalEsAssets;
var _install = require("../epm/elasticsearch/template/install");
var _install2 = require("../epm/elasticsearch/ingest_pipeline/install");
var _app_context = require("../app_context");
var _schedule = require("../../tasks/setup/schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Ensure ES assets shared by all Fleet index template are installed
 */
async function ensureFleetGlobalEsAssets({
  logger,
  soClient,
  esClient
}, options) {
  // Ensure Global Fleet ES assets are installed
  logger.debug('Creating Fleet component template and ingest pipeline');
  const globalAssetsRes = await Promise.all([(0, _install.ensureDefaultComponentTemplates)(esClient, logger),
  // returns an array
  (0, _install2.ensureFleetFinalPipelineIsInstalled)(esClient, logger), (0, _install2.ensureFleetEventIngestedPipelineIsInstalled)(esClient, logger)]);
  if (options !== null && options !== void 0 && options.reinstallPackages) {
    const assetResults = globalAssetsRes.flat();
    const createdAssets = assetResults.filter(asset => asset.isCreated);
    if (createdAssets.length > 0) {
      logger.info(`Global Fleet assets changed (${createdAssets.length} created: ${createdAssets.map(a => a.name).join(', ')}). Scheduling package reinstallation task.`);
      const taskManager = _app_context.appContextService.getTaskManagerStart();
      if (taskManager) {
        await (0, _schedule.scheduleSetupTask)(taskManager, {
          type: 'reinstallPackagesForGlobalAssetUpdate'
        });
      } else {
        logger.warn('Task manager not available, skipping deferred package reinstallation. ' + 'Packages may need to be manually reinstalled.');
      }
    }
  }
}