"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forEachMappings = exports.applyDocOnlyValueToMapping = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const forEachMappings = (mappingProperties, process) => {
  Object.keys(mappingProperties).forEach(mapping => {
    const property = mappingProperties[mapping];
    if (property.properties) {
      forEachMappings(property.properties, process);
    } else {
      process(property, mapping);
    }
  });
};
exports.forEachMappings = forEachMappings;
const applyDocOnlyValueToMapping = (mappingProp, name, featureMap, isDocValueOnlyNumericChanged, isDocValueOnlyOtherChanged) => {
  var _mapping$type, _mapping$type2;
  const mapping = mappingProp;
  const numericTypes = ['long', 'integer', 'short', 'byte', 'double', 'float', 'half_float', 'scaled_float', 'unsigned_long'];
  if (isDocValueOnlyNumericChanged && numericTypes.includes((_mapping$type = mapping.type) !== null && _mapping$type !== void 0 ? _mapping$type : '') && featureMap.features.doc_value_only_numeric !== undefined) {
    updateMapping(mapping, featureMap.features.doc_value_only_numeric);
  }
  const otherSupportedTypes = ['date', 'date_nanos', 'boolean', 'ip', 'geo_point', 'keyword'];
  if (isDocValueOnlyOtherChanged && name !== '@timestamp' && otherSupportedTypes.includes((_mapping$type2 = mapping.type) !== null && _mapping$type2 !== void 0 ? _mapping$type2 : '') && featureMap.features.doc_value_only_other !== undefined) {
    updateMapping(mapping, featureMap.features.doc_value_only_other);
  }
};
exports.applyDocOnlyValueToMapping = applyDocOnlyValueToMapping;
const updateMapping = (mapping, featureValue) => {
  if (featureValue === false && mapping.index === false) {
    delete mapping.index;
  }
  if (featureValue && !mapping.index) {
    mapping.index = false;
  }
};