"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupTransformsStep = cleanupTransformsStep;
exports.stepInstallTransforms = stepInstallTransforms;
var _install = require("../../../elasticsearch/transform/install");
var _utils = require("../../utils");
var _remove = require("../../remove");
var _types = require("../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallTransforms(context) {
  var _context$esReferences;
  const {
    packageInstallContext,
    esClient,
    savedObjectsClient,
    logger,
    force,
    authorizationHeader
  } = context;
  let esReferences = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : [];
  ({
    esReferences
  } = await (0, _utils.withPackageSpan)('Install transforms', () => (0, _install.installTransforms)({
    packageInstallContext,
    esClient,
    savedObjectsClient,
    logger,
    esReferences,
    force,
    authorizationHeader
  })));
  return {
    esReferences
  };
}
async function cleanupTransformsStep(context) {
  var _installedPkg$attribu;
  const {
    logger,
    esClient,
    installedPkg,
    retryFromLastState,
    force,
    initialState
  } = context;

  // In case of retry clean up previous installed assets
  if (!force && retryFromLastState && initialState === _types.INSTALL_STATES.INSTALL_TRANSFORMS && installedPkg !== null && installedPkg !== void 0 && (_installedPkg$attribu = installedPkg.attributes) !== null && _installedPkg$attribu !== void 0 && _installedPkg$attribu.installed_es && installedPkg.attributes.installed_es.length > 0) {
    const {
      installed_es: installedEs
    } = installedPkg.attributes;
    logger.debug('Retry transition - clean up transforms');
    await (0, _utils.withPackageSpan)('Retry transition - clean up ilm transforms', async () => {
      await (0, _remove.cleanupTransforms)(installedEs, esClient);
    });
  }
}