"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupEsqlViewsStep = cleanupEsqlViewsStep;
exports.stepInstallEsqlViews = stepInstallEsqlViews;
var _app_context = require("../../../../app_context");
var _utils = require("../../utils");
var _remove = require("../../remove");
var _types = require("../../../../../../common/types");
var _install = require("../../../elasticsearch/esql_views/install");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallEsqlViews(context) {
  var _ref, _ref2, _context$esReferences;
  const {
    savedObjectsClient,
    esClient,
    logger,
    packageInstallContext,
    installedPkg
  } = context;
  let esReferences = (_ref = (_ref2 = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : context.esReferences) !== null && _ref2 !== void 0 ? _ref2 : installedPkg === null || installedPkg === void 0 ? void 0 : installedPkg.attributes.installed_es) !== null && _ref !== void 0 ? _ref : [];
  if (_app_context.appContextService.getExperimentalFeatures().enableEsqlViewInstall !== true) {
    return {
      esReferences
    };
  }
  esReferences = await (0, _utils.withPackageSpan)('Install ESQL views', () => (0, _install.installEsqlViews)({
    packageInstallContext,
    esClient,
    savedObjectsClient,
    logger,
    esReferences
  }));
  return {
    esReferences
  };
}
async function cleanupEsqlViewsStep(context) {
  var _installedPkg$attribu;
  const {
    logger,
    installedPkg,
    esClient,
    retryFromLastState,
    force,
    initialState
  } = context;

  // In case of retry clean up previous installed esql views
  if (!force && retryFromLastState && initialState === _types.INSTALL_STATES.INSTALL_ESQL_VIEWS && installedPkg !== null && installedPkg !== void 0 && (_installedPkg$attribu = installedPkg.attributes) !== null && _installedPkg$attribu !== void 0 && _installedPkg$attribu.installed_es && installedPkg.attributes.installed_es.length > 0) {
    const {
      installed_es: installedEs
    } = installedPkg.attributes;
    logger.debug('Retry transition - clean up ESQL views');
    await (0, _utils.withPackageSpan)('Retry transition - clean up ESQL views', async () => {
      await (0, _remove.cleanupEsqlViews)(installedEs, esClient);
    });
  }
}