"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setVerificationResult = exports.setPackageInfo = exports.hasVerificationResult = exports.getVerificationResult = exports.getPackageInfo = exports.deleteVerificationResult = exports.deletePackageInfo = exports.clearVerificationResults = void 0;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sharedKey = ({
  name,
  version
}) => `${name}-${version}`;
const verificationResultCache = new Map();
const getVerificationResult = key => verificationResultCache.get(sharedKey(key));
exports.getVerificationResult = getVerificationResult;
const setVerificationResult = (key, value) => verificationResultCache.set(sharedKey(key), value);
exports.setVerificationResult = setVerificationResult;
const hasVerificationResult = key => verificationResultCache.has(sharedKey(key));
exports.hasVerificationResult = hasVerificationResult;
const clearVerificationResults = () => verificationResultCache.clear();
exports.clearVerificationResults = clearVerificationResults;
const deleteVerificationResult = key => verificationResultCache.delete(sharedKey(key));
exports.deleteVerificationResult = deleteVerificationResult;
const packageInfoCache = new Map();
const getPackageInfo = args => {
  return packageInfoCache.get(sharedKey(args));
};

/*
 * This cache should only be used to store "full" package info generated from the package archive.
 * NOT package info from the EPR API. This is because we parse extra fields from the archive
 * which are not provided by the registry API.
 */
exports.getPackageInfo = getPackageInfo;
const setPackageInfo = ({
  name,
  version,
  packageInfo
}) => {
  const logger = _.appContextService.getLogger();
  const key = sharedKey({
    name,
    version
  });
  logger.debug(`Setting package info to the cache for ${name}-${version}`);
  logger.trace(JSON.stringify(packageInfo));
  return packageInfoCache.set(key, packageInfo);
};
exports.setPackageInfo = setPackageInfo;
const deletePackageInfo = args => packageInfoCache.delete(sharedKey(args));
exports.deletePackageInfo = deletePackageInfo;