"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putDownloadSourcesHandler = exports.postDownloadSourcesHandler = exports.getOneDownloadSourcesHandler = exports.getDownloadSourcesHandler = exports.deleteDownloadSourcesHandler = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _download_source = require("../../services/download_source");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ensureNoDuplicateSecrets(downloadSource) {
  var _downloadSource$ssl, _downloadSource$secre, _downloadSource$secre2;
  if ((_downloadSource$ssl = downloadSource.ssl) !== null && _downloadSource$ssl !== void 0 && _downloadSource$ssl.key && (_downloadSource$secre = downloadSource.secrets) !== null && _downloadSource$secre !== void 0 && (_downloadSource$secre2 = _downloadSource$secre.ssl) !== null && _downloadSource$secre2 !== void 0 && _downloadSource$secre2.key) {
    throw _boom.default.badRequest('Cannot specify both ssl.key and secrets.ssl.key');
  }
}
const getDownloadSourcesHandler = async (context, request, response) => {
  const downloadSources = await _download_source.downloadSourceService.list();
  const body = {
    items: downloadSources.items,
    page: downloadSources.page,
    perPage: downloadSources.perPage,
    total: downloadSources.total
  };
  return response.ok({
    body
  });
};
exports.getDownloadSourcesHandler = getDownloadSourcesHandler;
const getOneDownloadSourcesHandler = async (context, request, response) => {
  try {
    const downloadSource = await _download_source.downloadSourceService.get(request.params.sourceId);
    const body = {
      item: downloadSource
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `Agent binary source ${request.params.sourceId} not found`
        }
      });
    }
    throw error;
  }
};
exports.getOneDownloadSourcesHandler = getOneDownloadSourcesHandler;
const putDownloadSourcesHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  ensureNoDuplicateSecrets(request.body);
  try {
    await _download_source.downloadSourceService.update(soClient, esClient, request.params.sourceId, request.body);
    const downloadSource = await _download_source.downloadSourceService.get(request.params.sourceId);
    if (downloadSource.is_default) {
      await _services.agentPolicyService.bumpAllAgentPolicies(esClient);
    } else {
      await _services.agentPolicyService.bumpAllAgentPoliciesForDownloadSource(esClient, downloadSource.id);
    }
    const body = {
      item: downloadSource
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `Download source ${request.params.sourceId} not found`
        }
      });
    }
    throw error;
  }
};
exports.putDownloadSourcesHandler = putDownloadSourcesHandler;
const postDownloadSourcesHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const {
    id,
    ...data
  } = request.body;
  ensureNoDuplicateSecrets(data);
  const downloadSource = await _download_source.downloadSourceService.create(soClient, esClient, data, {
    id
  });
  if (downloadSource.is_default) {
    await _services.agentPolicyService.bumpAllAgentPolicies(esClient);
  }
  const body = {
    item: downloadSource
  };
  return response.ok({
    body
  });
};
exports.postDownloadSourcesHandler = postDownloadSourcesHandler;
const deleteDownloadSourcesHandler = async (context, request, response) => {
  try {
    await _download_source.downloadSourceService.delete(request.params.sourceId);
    const body = {
      id: request.params.sourceId
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `Agent binary source ${request.params.sourceId} not found`
        }
      });
    }
    throw error;
  }
};
exports.deleteDownloadSourcesHandler = deleteDownloadSourcesHandler;