"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeAgentPrivilegeLevelHandler = exports.bulkChangeAgentsPrivilegeLevelHandler = void 0;
var _agents = require("../../services/agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const changeAgentPrivilegeLevelHandler = async (context, request, response) => {
  const [coreContext] = await Promise.all([context.core, context.fleet]);
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  const body = await (0, _agents.changeAgentPrivilegeLevel)(esClient, soClient, request.params.agentId, request.body);
  return response.ok({
    body
  });
};
exports.changeAgentPrivilegeLevelHandler = changeAgentPrivilegeLevelHandler;
const bulkChangeAgentsPrivilegeLevelHandler = async (context, request, response) => {
  const [coreContext] = await Promise.all([context.core, context.fleet]);
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  const {
    agents,
    ...options
  } = request.body;
  const agentOptions = Array.isArray(agents) ? {
    agentIds: agents
  } : {
    kuery: agents
  };
  const body = await (0, _agents.bulkChangeAgentsPrivilegeLevel)(esClient, soClient, {
    ...options,
    ...agentOptions
  });
  return response.ok({
    body
  });
};
exports.bulkChangeAgentsPrivilegeLevelHandler = bulkChangeAgentsPrivilegeLevelHandler;