"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModifiedILMs = getModifiedILMs;
var _services = require("../services");
var _default_settings = require("../services/epm/elasticsearch/template/default_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getModifiedILMs() {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const isILMPolicyDisabled = (_appContextService$ge = (_appContextService$ge2 = _services.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isILMPolicyDisabled) {
    return [];
  }
  const dataStreamTypes = ['logs', 'metrics', 'synthetics'];
  const ilmPolicies = await (0, _default_settings.getILMPolicies)(dataStreamTypes);
  const modifiedILMs = [];
  ilmPolicies.forEach((policies, dataStreamType) => {
    var _deprecatedILMPolicy$, _newILMPolicy$version;
    const {
      deprecatedILMPolicy,
      newILMPolicy
    } = policies;
    if (((_deprecatedILMPolicy$ = deprecatedILMPolicy === null || deprecatedILMPolicy === void 0 ? void 0 : deprecatedILMPolicy.version) !== null && _deprecatedILMPolicy$ !== void 0 ? _deprecatedILMPolicy$ : 1) > 1) {
      modifiedILMs.push(dataStreamType);
    }
    if (((_newILMPolicy$version = newILMPolicy === null || newILMPolicy === void 0 ? void 0 : newILMPolicy.version) !== null && _newILMPolicy$version !== void 0 ? _newILMPolicy$version : 1) > 1) {
      modifiedILMs.push(`${dataStreamType}@lifecycle`);
    }
  });
  return modifiedILMs;
}