"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StandaloneSteps = exports.ManagedSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("../../../../common/services");
var _services2 = require("../../cloud_security_posture/services");
var _enrollment_instructions = require("../../enrollment_instructions");
var _hooks = require("../../../hooks");
var _hooks2 = require("../hooks");
var _confirm_agent_enrollment = require("../confirm_agent_enrollment");
var _cloud_security_posture = require("../../cloud_security_posture");
var _use_agent_policies_with_fips = require("../../../applications/fleet/hooks/use_agent_policies_with_fips");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/compute_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StandaloneSteps = ({
  agentPolicy,
  agentPolicies,
  selectedPolicy,
  selectedPolicyId,
  setSelectedPolicyId,
  refreshAgentPolicies,
  mode,
  setMode,
  selectionType,
  selectedApiKeyId,
  setSelectedAPIKeyId,
  isK8s,
  cloudSecurityIntegration,
  downloadSource,
  downloadSourceProxy
}) => {
  const {
    yaml,
    onCreateApiKey,
    isCreatingApiKey,
    apiKey,
    downloadYaml
  } = (0, _hooks2.useFetchFullPolicy)(selectedPolicy, isK8s);
  const agentVersion = (0, _hooks.useAgentVersion)();
  const instructionsSteps = (0, _react.useMemo)(() => {
    var _selectedPolicy$packa;
    const standaloneInstallCommands = (0, _enrollment_instructions.StandaloneInstructions)({
      agentVersion: agentVersion || '',
      downloadSource,
      downloadSourceProxy
    });
    const steps = !agentPolicy ? [(0, _.AgentPolicySelectionStep)({
      selectedPolicy,
      selectedPolicyId,
      agentPolicies,
      selectedApiKeyId,
      setSelectedAPIKeyId,
      setSelectedPolicyId,
      refreshAgentPolicies
    })] : [];
    if (selectionType === 'radio') {
      steps.push((0, _.InstallationModeSelectionStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        mode,
        setMode
      }));
    }
    steps.push((0, _.ConfigureStandaloneAgentStep)({
      isK8s,
      selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
      yaml,
      downloadYaml,
      apiKey,
      onCreateApiKey,
      isCreatingApiKey
    }));
    steps.push((0, _.InstallStandaloneAgentStep)({
      installCommand: standaloneInstallCommands,
      isK8s,
      cloudSecurityIntegration,
      rootIntegrations: (0, _services.getRootIntegrations)((_selectedPolicy$packa = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.package_policies) !== null && _selectedPolicy$packa !== void 0 ? _selectedPolicy$packa : []),
      nonFipsIntegrations: (0, _use_agent_policies_with_fips.getAgentPoliciesWithNonFipsIntegrations)(selectedPolicy)
    }));
    return steps;
  }, [agentVersion, downloadSource, downloadSourceProxy, agentPolicy, selectedPolicy, agentPolicies, selectedApiKeyId, setSelectedAPIKeyId, setSelectedPolicyId, selectedPolicyId, refreshAgentPolicies, selectionType, isK8s, yaml, downloadYaml, apiKey, onCreateApiKey, isCreatingApiKey, cloudSecurityIntegration, mode, setMode]);
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: instructionsSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 10
    }
  });
};
exports.StandaloneSteps = StandaloneSteps;
const ManagedSteps = ({
  agentPolicy,
  agentPolicies,
  selectedPolicy,
  selectedPolicyId,
  setSelectedPolicyId,
  selectedApiKeyId,
  setSelectedAPIKeyId,
  fleetServerHost,
  fleetServerHostConfig,
  fleetProxy,
  downloadSource,
  downloadSourceProxy,
  refreshAgentPolicies,
  mode,
  setMode,
  selectionType,
  onClickViewAgents,
  isK8s,
  cloudSecurityIntegration,
  installedPackagePolicy
}) => {
  var _agentPolicy$package_;
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const link = docLinks.links.fleet.troubleshooting;
  const [agentDataConfirmed, setAgentDataConfirmed] = (0, _react.useState)(false);
  const apiKey = (0, _hooks.useGetOneEnrollmentAPIKey)(selectedApiKeyId);
  const apiKeyData = apiKey === null || apiKey === void 0 ? void 0 : apiKey.data;
  const enrollToken = apiKey.data ? apiKey.data.item.api_key : '';
  const {
    enrolledAgentIds
  } = (0, _confirm_agent_enrollment.usePollingAgentCount)((selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id) || '');
  const agentVersion = (0, _hooks.useAgentVersion)();
  const {
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  } = (0, _services2.getGcpIntegrationDetailsFromAgentPolicy)(selectedPolicy);
  const showInstallServers = (0, _services.hasInstallServersInputs)((_agentPolicy$package_ = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.package_policies) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : []);
  const installManagedCommands = (0, _enrollment_instructions.ManualInstructions)({
    apiKey: enrollToken,
    fleetServerHost,
    fleetServerHostConfig,
    fleetProxy,
    downloadSource,
    downloadSourceProxy,
    agentVersion: agentVersion || '',
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType,
    showInstallServers
  });
  const instructionsSteps = (0, _react.useMemo)(() => {
    const steps = !agentPolicy ? [(0, _.AgentPolicySelectionStep)({
      selectedPolicy,
      selectedPolicyId,
      agentPolicies,
      selectedApiKeyId,
      setSelectedAPIKeyId,
      setSelectedPolicyId,
      refreshAgentPolicies
    })] : [(0, _.AgentEnrollmentKeySelectionStep)({
      selectedPolicy,
      selectedApiKeyId,
      setSelectedAPIKeyId
    })];
    if (selectionType === 'radio') {
      steps.push((0, _.InstallationModeSelectionStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        mode,
        setMode
      }));
    }
    if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.isCloudFormation) {
      steps.push((0, _cloud_security_posture.InstallCloudFormationManagedAgentStep)({
        apiKeyData,
        selectedApiKeyId,
        enrollToken,
        cloudSecurityIntegration,
        fleetServerHost
      }));
    } else if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.cloudShellUrl) {
      steps.push((0, _cloud_security_posture.InstallGoogleCloudShellManagedAgentStep)({
        apiKeyData,
        selectedApiKeyId,
        cloudShellUrl: cloudSecurityIntegration.cloudShellUrl,
        cloudShellCommand: installManagedCommands.googleCloudShell,
        projectId: gcpProjectId
      }));
    } else if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.isAzureArmTemplate) {
      steps.push((0, _cloud_security_posture.InstallAzureArmTemplateManagedAgentStep)({
        selectedApiKeyId,
        apiKeyData,
        enrollToken,
        cloudSecurityIntegration,
        agentPolicy
      }));
    } else {
      var _selectedPolicy$packa2;
      steps.push((0, _.InstallManagedAgentStep)({
        installCommand: installManagedCommands,
        apiKeyData,
        selectedApiKeyId,
        isK8s,
        cloudSecurityIntegration,
        fleetServerHost,
        enrollToken,
        rootIntegrations: (0, _services.getRootIntegrations)((_selectedPolicy$packa2 = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.package_policies) !== null && _selectedPolicy$packa2 !== void 0 ? _selectedPolicy$packa2 : []),
        nonFipsIntegrations: (0, _use_agent_policies_with_fips.getAgentPoliciesWithNonFipsIntegrations)(selectedPolicy)
      }));
    }
    if (selectedApiKeyId && apiKeyData) {
      steps.push((0, _.AgentEnrollmentConfirmationStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        onClickViewAgents,
        troubleshootLink: link,
        agentCount: enrolledAgentIds.length,
        isLongEnrollment: cloudSecurityIntegration !== undefined
      }));
    }
    if (selectedPolicy) {
      steps.push((0, _.IncomingDataConfirmationStep)({
        agentIds: enrolledAgentIds,
        agentDataConfirmed,
        setAgentDataConfirmed,
        installedPolicy: installedPackagePolicy,
        troubleshootLink: link
      }));
    }
    return steps;
  }, [agentPolicy, selectedPolicy, agentPolicies, selectedApiKeyId, setSelectedAPIKeyId, setSelectedPolicyId, selectedPolicyId, refreshAgentPolicies, selectionType, cloudSecurityIntegration, apiKeyData, mode, setMode, enrollToken, fleetServerHost, installManagedCommands, gcpProjectId, isK8s, onClickViewAgents, link, enrolledAgentIds, agentDataConfirmed, installedPackagePolicy]);
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: instructionsSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 10
    }
  });
};
exports.ManagedSteps = ManagedSteps;