"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstalledIntegrations = useInstalledIntegrations;
var _react = require("react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _hooks = require("../../../../../hooks");
var _hooks2 = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIntegrationStatus(item, isUpgrading, isUninstalling, isRollingback) {
  var _item$status;
  if (isUpgrading) {
    return 'upgrading';
  }
  if (isUninstalling) {
    return 'uninstalling';
  }
  if (isRollingback) {
    return 'rolling_back';
  }
  if (item.status === 'install_failed') {
    return 'install_failed';
  } else if (item.status === 'installed') {
    var _item$installationInf, _item$installationInf2, _ref;
    const isUpgradeFailed = item === null || item === void 0 ? void 0 : (_item$installationInf = item.installationInfo) === null || _item$installationInf === void 0 ? void 0 : (_item$installationInf2 = _item$installationInf.latest_install_failed_attempts) === null || _item$installationInf2 === void 0 ? void 0 : _item$installationInf2.some(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version));
    const isUpgradeAvailable = (_ref = (item === null || item === void 0 ? void 0 : item.installationInfo) && (0, _lt.default)(item.installationInfo.version, item.version)) !== null && _ref !== void 0 ? _ref : false;
    return isUpgradeFailed ? 'upgrade_failed' : isUpgradeAvailable ? 'upgrade_available' : 'installed';
  }
  return (_item$status = item.status) !== null && _item$status !== void 0 ? _item$status : 'not_installed';
}
function useInstalledIntegrations(filters, pagination, upgradingIntegrations, uninstallingIntegrations, rollingbackIntegrations, prereleaseIntegrationsEnabled) {
  const {
    data,
    isInitialLoading,
    isLoading
  } = (0, _hooks2.useGetPackagesQuery)({
    withPackagePoliciesCount: true,
    prerelease: prereleaseIntegrationsEnabled
  });
  const internalInstalledPackages = (0, _react.useMemo)(() => {
    var _data$items$filter;
    return (
      // Filter not installed packages
      ((_data$items$filter = data === null || data === void 0 ? void 0 : data.items.filter(item => item.status !== 'not_installed')) !== null && _data$items$filter !== void 0 ? _data$items$filter : [] // Add extra properties
      ).map(item => {
        var _upgradingIntegration, _uninstallingIntegrat, _rollingbackIntegrati;
        return {
          ...item,
          ui: {
            installation_status: getIntegrationStatus(item, (_upgradingIntegration = upgradingIntegrations === null || upgradingIntegrations === void 0 ? void 0 : upgradingIntegrations.some(u => u.name === item.name)) !== null && _upgradingIntegration !== void 0 ? _upgradingIntegration : false, (_uninstallingIntegrat = uninstallingIntegrations === null || uninstallingIntegrations === void 0 ? void 0 : uninstallingIntegrations.some(u => u.name === item.name)) !== null && _uninstallingIntegrat !== void 0 ? _uninstallingIntegrat : false, (_rollingbackIntegrati = rollingbackIntegrations === null || rollingbackIntegrations === void 0 ? void 0 : rollingbackIntegrations.some(u => u.name === item.name)) !== null && _rollingbackIntegrati !== void 0 ? _rollingbackIntegrati : false)
          }
        };
      })
    );
  }, [data, upgradingIntegrations, uninstallingIntegrations, rollingbackIntegrations]);
  const localSearch = (0, _hooks.useLocalSearch)(internalInstalledPackages, isInitialLoading);
  const internalInstalledPackagesFiltered = (0, _react.useMemo)(() => {
    const searchResults = filters.q && localSearch ? localSearch.search(filters.q) : [];
    return internalInstalledPackages
    // Filter according to filters
    .filter(item => {
      var _item$categories;
      const validInstalationStatus = filters.installationStatus ? filters.installationStatus.includes(item.ui.installation_status) : true;
      const validSearchTerms = filters.q ? searchResults.find(s => s.id === item.id) : true;
      const validCustomIntegrations = filters.customIntegrations ? (_item$categories = item.categories) === null || _item$categories === void 0 ? void 0 : _item$categories.includes('custom') : true;
      return validInstalationStatus && validSearchTerms && validCustomIntegrations;
    });
  }, [internalInstalledPackages, localSearch, filters]);
  const countPerStatus = (0, _react.useMemo)(() => {
    return internalInstalledPackagesFiltered.reduce((acc, item) => {
      if (!acc[item.ui.installation_status]) {
        acc[item.ui.installation_status] = 0;
      }
      acc[item.ui.installation_status]++;
      return acc;
    }, {});
  }, [internalInstalledPackagesFiltered]);
  const customIntegrationsCount = (0, _react.useMemo)(() => {
    return internalInstalledPackages.reduce((acc, item) => {
      var _item$categories2;
      return (_item$categories2 = item.categories) !== null && _item$categories2 !== void 0 && _item$categories2.includes('custom') ? acc + 1 : acc;
    }, 0);
  }, [internalInstalledPackages]);
  const installedPackages = (0, _react.useMemo)(() => {
    // Pagination
    const startAt = (pagination.currentPage - 1) * pagination.pageSize;
    return internalInstalledPackagesFiltered.slice(startAt, startAt + pagination.pageSize);
  }, [internalInstalledPackagesFiltered, pagination.currentPage, pagination.pageSize]);
  return {
    total: internalInstalledPackagesFiltered.length,
    countPerStatus,
    customIntegrationsCount,
    installedPackages,
    isInitialLoading,
    isLoading
  };
}