"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_installed_integrations_actions = require("../hooks/use_installed_integrations_actions");
var _services = require("../../../../../services");
var _hooks = require("../../../../../hooks");
var _use_rollback_available = require("../hooks/use_rollback_available");
var _integration_knowledge_flyout = require("./integration_knowledge_flyout");
var _eis_cost_tour = require("./eis_cost_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/installed_integration_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InstalledIntegrationsActionMenu = ({
  selectedItems
}) => {
  var _cloud$isCloudEnabled;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [showIntegrationKnowledgeFlyout, setShowIntegrationKnowledgeFlyout] = (0, _react.useState)(false);
  const {
    enablePackageRollback
  } = _services.ExperimentalFeaturesService.get();
  const licenseService = (0, _hooks.useLicense)();
  const {
    cloud,
    docLinks
  } = (0, _hooks.useStartServices)();
  const button = /*#__PURE__*/_react.default.createElement(_eis_cost_tour.EisCostTour, {
    ctaLink: docLinks.links.enterpriseSearch.elasticInferenceService,
    isCloudEnabled: (_cloud$isCloudEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) !== null && _cloud$isCloudEnabled !== void 0 ? _cloud$isCloudEnabled : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setIsPopoverOpen(s => !s),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.actionButton",
    defaultMessage: "Actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
  const {
    actions: {
      bulkUpgradeIntegrationsWithConfirmModal,
      bulkUninstallIntegrationsWithConfirmModal,
      bulkRollbackIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  const openUpgradeModal = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
    return bulkUpgradeIntegrationsWithConfirmModal(selectedItems);
  }, [selectedItems, bulkUpgradeIntegrationsWithConfirmModal]);
  const openUninstallModal = (0, _react.useCallback)(async () => {
    setIsPopoverOpen(false);
    return bulkUninstallIntegrationsWithConfirmModal(selectedItems);
  }, [selectedItems, bulkUninstallIntegrationsWithConfirmModal]);
  const openRollbackModal = (0, _react.useCallback)(async () => {
    setIsPopoverOpen(false);
    return bulkRollbackIntegrationsWithConfirmModal(selectedItems);
  }, [selectedItems, bulkRollbackIntegrationsWithConfirmModal]);
  const openManageIntegrationKnowledgeFlyout = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
    setShowIntegrationKnowledgeFlyout(true);
  }, []);
  const isRollbackAvailablePackages = (0, _use_rollback_available.useRollbackAvailablePackages)(selectedItems);
  const items = (0, _react.useMemo)(() => {
    const hasUpgreadableIntegrations = selectedItems.some(item => item.ui.installation_status === 'upgrade_available' || item.ui.installation_status === 'upgrade_failed' || item.ui.installation_status === 'install_failed');
    const hasUninstallableIntegrations = selectedItems.some(item => {
      var _item$packagePolicies, _item$packagePolicies2;
      return ((_item$packagePolicies = (_item$packagePolicies2 = item.packagePoliciesInfo) === null || _item$packagePolicies2 === void 0 ? void 0 : _item$packagePolicies2.count) !== null && _item$packagePolicies !== void 0 ? _item$packagePolicies : 0) > 0;
    });
    const hasRollbackableIntegrations = selectedItems.some(item => isRollbackAvailablePackages[item.name]);
    const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "integrationKnowledge",
      icon: "gear",
      onClick: openManageIntegrationKnowledgeFlyout,
      disabled: !licenseService.isEnterprise(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.manageIntegrationKnowledgeButton",
      defaultMessage: 'Manage integration knowledge',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }))];
    if (selectedItems.length > 0) {
      menuItems.push(...[/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "upgrade",
        icon: "refresh",
        disabled: !hasUpgreadableIntegrations,
        onClick: openUpgradeModal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epmInstalledIntegrations.bulkUpgradeButton",
        defaultMessage: 'Upgrade {count, plural, one {# integration} other {# integrations}}',
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "uninstall",
        icon: "trash",
        disabled: hasUninstallableIntegrations,
        onClick: openUninstallModal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 11
        }
      }, hasUninstallableIntegrations ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epmInstalledIntegrations.uninstallDisabledTooltip",
          defaultMessage: "Can't uninstall integrations that are attached to agent policies",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 19
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epmInstalledIntegrations.bulkUninstallButton",
        defaultMessage: 'Uninstall {count, plural, one {# integration} other {# integrations}}',
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 17
        }
      })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epmInstalledIntegrations.bulkUninstallButton",
        defaultMessage: 'Uninstall {count, plural, one {# integration} other {# integrations}}',
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 15
        }
      })), ...(enablePackageRollback ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "rollback",
        icon: "returnKey",
        disabled: !hasRollbackableIntegrations,
        onClick: openRollbackModal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epmInstalledIntegrations.bulkRollbackButton",
        defaultMessage: 'Roll back {count, plural, one {# integration} other {# integrations}}',
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 19
        }
      }))] : [])]);
    }
    return menuItems;
  }, [selectedItems, openUninstallModal, openUpgradeModal, openRollbackModal, enablePackageRollback, licenseService, openManageIntegrationKnowledgeFlyout, isRollbackAvailablePackages]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "fleet.epmInstalledIntegrations.bulkActionPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  })), showIntegrationKnowledgeFlyout && /*#__PURE__*/_react.default.createElement(_integration_knowledge_flyout.IntegrationKnowledgeFlyout, {
    onClose: () => setShowIntegrationKnowledgeFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }));
};
exports.InstalledIntegrationsActionMenu = InstalledIntegrationsActionMenu;