"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAvailableCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/update_available_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UpdateAvailableCallout = ({
  version,
  toggleChangelogModal,
  breakingChanges
}) => {
  var _breakingChanges$chan, _breakingChanges$chan2, _breakingChanges$chan3, _breakingChanges$chan4;
  const isOneChange = (breakingChanges === null || breakingChanges === void 0 ? void 0 : breakingChanges.changelog.length) === 1 && breakingChanges.changelog[0].changes.length === 1;
  const checkboxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'understoodBreakingChangeCheckbox'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultTitle = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.updatesAvailable",
    defaultMessage: "New version available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
  const titleWithBreakingChanges = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.updatesAvailableWithBreakingChanges",
    defaultMessage: "New version available: Action required due to breaking changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: breakingChanges ? titleWithBreakingChanges : defaultTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, isOneChange ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integration.settings.versionInfo.updatesAvailableWithSingleBreakingChangesBodyIntro",
    defaultMessage: 'Version {version} includes new features and a breaking change that may affect your current setup:',
    values: {
      version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("i", {
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.medium};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, `"${(_breakingChanges$chan = breakingChanges.changelog) === null || _breakingChanges$chan === void 0 ? void 0 : (_breakingChanges$chan2 = _breakingChanges$chan[0]) === null || _breakingChanges$chan2 === void 0 ? void 0 : (_breakingChanges$chan3 = _breakingChanges$chan2.changes[0]) === null || _breakingChanges$chan3 === void 0 ? void 0 : _breakingChanges$chan3.description}"`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integration.settings.versionInfo.updatesAvailableWithSingleBreakingChangesBodyEnd",
    defaultMessage: "Please review the changes carefully before upgrading.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })) : breakingChanges ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integration.settings.versionInfo.updatesAvailableWithBreakingChangesBody",
    defaultMessage: "Version {version} includes new features and breaking changes that may affect your current setup. Please review the changes carefully before upgrading.",
    values: {
      version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integration.settings.versionInfo.updatesAvailableBody",
    defaultMessage: "Upgrade to version {version} to get the latest features.",
    values: {
      version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, breakingChanges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(BreakingChangesButton, {
    href: isOneChange ? (_breakingChanges$chan4 = breakingChanges.changelog) === null || _breakingChanges$chan4 === void 0 ? void 0 : _breakingChanges$chan4[0].changes[0].link : undefined,
    onClick: breakingChanges.onOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    onClick: toggleChangelogModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integration.settings.versionInfo.updatesAvailableChangelogLink",
    defaultMessage: "View changelog",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  })))), breakingChanges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkboxId,
    label: "I've reviewed the breaking changes and understand the impact.",
    onChange: breakingChanges.toggleIsUnderstood,
    checked: breakingChanges.isUnderstood,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  })));
};
exports.UpdateAvailableCallout = UpdateAvailableCallout;
const BreakingChangesButton = ({
  href,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const buttonCSS = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundFilledWarning};
  `;
  if (href) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      css: buttonCSS,
      href: href,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.versionInfo.reviewBreakingChangesButton",
      defaultMessage: "Review breaking changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "popout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    css: buttonCSS,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.reviewBreakingChangesButton",
    defaultMessage: "Review breaking changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }));
};