"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSLFormSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _multi_row_input = require("../multi_row_input");
var _output_form_secret_form_row = require("../edit_output_flyout/output_form_secret_form_row");
var _types = require("../../../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_server_hosts_flyout/ssl_form_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SSLFormSection = props => {
  const {
    inputs,
    useOutputSecretsStorage,
    useSSLSecretsStorage,
    isConvertedToSecret
  } = props;
  const clientAuthenticationsOptions = [{
    id: _types.clientAuth.None,
    label: 'None',
    'data-test-subj': 'clientAuthNoneRadioButton'
  }, {
    id: _types.clientAuth.Required,
    label: 'Required',
    'data-test-subj': 'clientAuthUsernamePasswordRadioButton'
  }, {
    id: _types.clientAuth.Optional,
    label: 'Optional',
    'data-test-subj': 'clientAuthSSLRadioButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedSSLOptions",
    "data-test-subj": "advancedSSLOptionsButton",
    buttonClassName: "ingest-active-button",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerHosts.SSLOptionsToggleLabel",
      defaultMessage: "Authentication",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerHosts.SSLOptionsToggleLabel",
      defaultMessage: "Set up a TLS secure connection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify the CA certificate(s) that signed the Elastic Agent client certificates connecting to this Fleet Server. Fleet Server trusts these CAs when verifying incoming connections.'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Fleet Server > Elastic Agents certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslCertificateInputLabel",
      defaultMessage: "Fleet Server > SSL server certificate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    })
  }, inputs.sslCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL certificate used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))), !useSSLSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslKeyInputLabel",
      defaultMessage: "Fleet Server > SSL server private key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 17
      }
    })
  }, inputs.sslKeyInput.formRowProps, {
    useSecretsStorage: useSSLSecretsStorage,
    disabled: !useSSLSecretsStorage,
    secretType: "ssl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL key used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeySecretInputTitle', {
      defaultMessage: 'Fleet Server > SSL server private key'
    })
  }, inputs.sslKeySecretInput.formRowProps, {
    useSecretsStorage: useSSLSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    cancelEdit: inputs.sslKeySecretInput.cancelEdit,
    secretType: "ssl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeySecretInput.props, {
    "data-test-subj": "sslKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeySecretInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL key used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify the Elasticsearch CA certificate(s) that Fleet Server should trust when connecting to Elasticsearch.'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Fleet Server > Elasticsearch certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslEsCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslEsCertificateInputLabel",
      defaultMessage: "Fleet Server > SSL client certificate for Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    })
  }, inputs.sslEsCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslEsCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateInputPlaceholder', {
      defaultMessage: 'Specify the SSL client certificate that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }))), !useOutputSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslEsKeyInputLabel",
      defaultMessage: "Fleet Server > SSL private key for Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 17
      }
    })
  }, inputs.sslESKeyInput.formRowProps, {
    useSecretsStorage: useOutputSecretsStorage,
    disabled: !useOutputSecretsStorage,
    secretType: "output",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslESKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsKeyInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsKeySecretInputTitle', {
      defaultMessage: 'Fleet Server > SSL private key for Elasticsearch'
    })
  }, inputs.sslESKeySecretInput.formRowProps, {
    useSecretsStorage: useOutputSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslESKey,
    cancelEdit: inputs.sslESKeySecretInput.cancelEdit,
    secretType: "output",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslESKeySecretInput.props, {
    "data-test-subj": "sslESKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslESKeySecretInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server CA certificate that Elastic Agents should trust when connecting to Fleet Server.'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Elastic Agent > Fleet Server certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslAgentCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslAgentCertificateInputLabel",
      defaultMessage: "Elastic Agent > SSL client certificate for Fleet Server",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 15
      }
    })
  }, inputs.sslAgentCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslAgentCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentCertificateInputPlaceholder', {
      defaultMessage: 'Specify the SSL client certificate that Elastic Agents should use when connecting to the Fleet Server. Only needed for mTLS between Elastic Agent and Fleet Server.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 13
    }
  }))), !useSSLSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslAgentKeyInputLabel",
      defaultMessage: "Elastic Agent > SSL private key for Fleet Server",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 17
      }
    })
  }, inputs.sslAgentKeyInput.formRowProps, {
    useSecretsStorage: useSSLSecretsStorage,
    disabled: !useSSLSecretsStorage,
    secretType: "ssl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslAgentKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentKeyInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that Elastic Agents should use when connecting to Fleet Server. Only needed for mTLS between Elastic Agent and Fleet Server.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentKeySecretInputTitle', {
      defaultMessage: 'Elastic Agent > SSL private key for Fleet Server'
    })
  }, inputs.sslAgentKeySecretInput.formRowProps, {
    useSecretsStorage: useSSLSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslAgentKey,
    cancelEdit: inputs.sslAgentKeySecretInput.cancelEdit,
    secretType: "ssl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslAgentKeySecretInput.props, {
    "data-test-subj": "sslAgentKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslAgentKeySecretInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that Elastic Agents should use when connecting to Fleet Server. Only needed for mTLS between Elastic Agent and Fleet Server.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.clientAuthenticationInputLabel",
      defaultMessage: "Client auth",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    style: {
      flexDirection: 'row',
      flexWrap: 'wrap',
      columnGap: 30
    },
    "data-test-subj": 'fleetServerHosts.clientAuthenticationRadioInput',
    options: clientAuthenticationsOptions,
    compressed: true,
    name: "clientAuth"
  }, inputs.sslClientAuthInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 13
    }
  }))))));
};
exports.SSLFormSection = SSLFormSection;