"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCountsForDownloadSource = getCountsForDownloadSource;
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getCountsForDownloadSource(downloadSource) {
  var _agentPolicies$data$i, _agentPolicies$data, _agentPolicies$data$i2;
  let kuery = `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.download_source_id:"${downloadSource.id}"`;
  if (downloadSource.is_default) {
    kuery += ` or (not ${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.download_source_id:*)`;
  }
  const agentPolicies = await (0, _hooks.sendGetAgentPolicies)({
    kuery,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT
  });
  if (agentPolicies.error) {
    throw agentPolicies.error;
  }
  const agentPolicyCount = (_agentPolicies$data$i = (_agentPolicies$data = agentPolicies.data) === null || _agentPolicies$data === void 0 ? void 0 : (_agentPolicies$data$i2 = _agentPolicies$data.items) === null || _agentPolicies$data$i2 === void 0 ? void 0 : _agentPolicies$data$i2.length) !== null && _agentPolicies$data$i !== void 0 ? _agentPolicies$data$i : 0;
  let agentCount = 0;
  if (agentPolicyCount > 0) {
    var _agentPolicies$data2, _agents$data$total, _agents$data;
    const agents = await (0, _hooks.sendGetAgents)({
      page: 1,
      perPage: 0,
      showInactive: false,
      kuery: (_agentPolicies$data2 = agentPolicies.data) === null || _agentPolicies$data2 === void 0 ? void 0 : _agentPolicies$data2.items.map(policy => `policy_id:"${policy.id}"`).join(' or ')
    });
    if (agents.error) {
      throw agents.error;
    }
    agentCount = (_agents$data$total = (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.total) !== null && _agents$data$total !== void 0 ? _agents$data$total : 0;
  }
  return {
    agentPolicyCount,
    agentCount
  };
}