"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageAutoUpgradeAgentsModal = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../hooks");
var _services = require("../../../../../../../common/services");
var _agent_policy = require("../../../../../../hooks/use_request/agent_policy");
var _agent_upgrade_modal = require("../agent_upgrade_modal");
var _status_column = require("./status_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/manage_auto_upgrade_agents_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManageAutoUpgradeAgentsModal = ({
  onClose,
  agentPolicy,
  agentCount
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [targetVersions, setTargetVersions] = (0, _react.useState)(agentPolicy.required_versions || []);
  const {
    data: agentsAvailableVersions
  } = (0, _hooks.useGetAgentsAvailableVersionsQuery)({
    enabled: true
  });
  const latestVersion = agentsAvailableVersions === null || agentsAvailableVersions === void 0 ? void 0 : agentsAvailableVersions.items[0];
  const [errors, setErrors] = (0, _react.useState)([]);
  const [fleetServerAgents, setFleetServerAgents] = (0, _react.useState)([]);

  // Fetch fleet server agents on mount
  (0, _react.useEffect)(() => {
    async function fetchFleetServerAgents() {
      try {
        const {
          allFleetServerAgents
        } = await (0, _hooks.sendGetAllFleetServerAgents)();
        setFleetServerAgents(allFleetServerAgents || []);
      } catch (err) {
        // If we can't fetch fleet servers, continue without validation
        // (e.g., in serverless where there are no fleet server agents)
      }
    }
    fetchFleetServerAgents();
  }, []);
  const targetVersionsChanged = (0, _react.useMemo)(() => {
    return (0, _lodash.isEqual)(targetVersions, agentPolicy.required_versions || []) === false;
  }, [targetVersions, agentPolicy.required_versions]);

  // Check if any target version is higher than fleet server version
  const fleetServerVersionWarning = (0, _react.useMemo)(() => {
    const invalidVersions = new Set();
    for (const targetVersion of targetVersions) {
      if (targetVersion.version) {
        const isValid = (0, _services.isAgentVersionLessThanFleetServer)(targetVersion.version, fleetServerAgents);
        if (!isValid) {
          invalidVersions.add(targetVersion.version);
        }
      }
    }
    const uniqueInvalidVersions = Array.from(invalidVersions);
    if (uniqueInvalidVersions.length > 0) {
      // Get the message for the first invalid version to get the Fleet Server version
      const baseMessage = (0, _services.getFleetServerVersionMessage)(uniqueInvalidVersions[0], fleetServerAgents);

      // If multiple invalid versions, customize the message and return a more detailed message
      if (uniqueInvalidVersions.length > 1) {
        const fleetServerVersions = fleetServerAgents.map(agent => agent.local_metadata.elastic.agent.version);
        const maxFleetServerVersion = (0, _services.getMaxVersion)(fleetServerVersions);
        const message = `Cannot upgrade to versions ${uniqueInvalidVersions.join(', ')} because they are higher than the latest fleet server version ${maxFleetServerVersion}.`;
        return message;
      }
      return baseMessage;
    }
    return null;
  }, [targetVersions, fleetServerAgents]);
  const submitUpdateAgentPolicy = async () => {
    setIsLoading(true);
    let isSuccess = false;
    try {
      await (0, _agent_policy.sendUpdateAgentPolicyForRq)(agentPolicy.id, {
        name: agentPolicy.name,
        namespace: agentPolicy.namespace,
        required_versions: targetVersions,
        // required_versions are not sent to agents, so no need to bump revision
        bumpRevision: false
      });
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.manageAutoUpgradeAgents.successNotificationTitle', {
        defaultMessage: "Successfully updated ''{name}'' auto-upgrade agents settings",
        values: {
          name: agentPolicy.name
        }
      }));
      isSuccess = true;
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.manageAutoUpgradeAgents.errorNotificationTitle', {
        defaultMessage: 'Unable to update agent policy'
      }));
    }
    setIsLoading(false);
    onClose(isSuccess);
  };
  async function onSubmit() {
    await submitUpdateAgentPolicy();
  }
  async function updateTargetVersions(newVersions) {
    const error = (0, _services.checkTargetVersionsValidity)(newVersions);
    setErrors(error ? [error] : []);
    setTargetVersions(newVersions);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "manageAutoUpgradeAgentsModal",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.modalTitle",
      defaultMessage: "Manage auto-upgrade agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }),
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => onClose(false),
    onConfirm: onSubmit,
    confirmButtonDisabled: isLoading || errors.length > 0 || !targetVersionsChanged || !!fleetServerVersionWarning,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.saveButtonLabel",
      defaultMessage: "Save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }),
    style: {
      width: 1000
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAutoUpgradeAgents.descriptionText",
    defaultMessage: "Add the target agent version for automatic upgrades.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })), fleetServerVersionWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_upgrade_modal.UpgradeModalWarningCallout, {
    warningMessage: fleetServerVersionWarning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TargetVersionsForm, {
    targetVersions: targetVersions,
    agentsAvailableVersions: agentsAvailableVersions,
    errors: errors,
    updateTargetVersions: updateTargetVersions,
    agentPolicyId: agentPolicy.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      updateTargetVersions([...targetVersions, {
        version: latestVersion || '',
        percentage: targetVersions.length === 0 ? 100 : 1
      }]);
    },
    iconType: "plusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAutoUpgradeAgents.addVersionButton",
    defaultMessage: "Add target version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }))))));
};
exports.ManageAutoUpgradeAgentsModal = ManageAutoUpgradeAgentsModal;
const TargetVersionsForm = ({
  targetVersions,
  agentsAvailableVersions,
  errors,
  updateTargetVersions,
  agentPolicyId
}) => {
  const onRemove = (0, _react.useCallback)(index => {
    updateTargetVersions(targetVersions.filter((_, i) => i !== index));
  }, [targetVersions, updateTargetVersions]);
  const onUpdate = (0, _react.useCallback)((index, version, percentage) => {
    updateTargetVersions(targetVersions.map((targetVersion, i) => i === index ? {
      version,
      percentage
    } : targetVersion));
  }, [targetVersions, updateTargetVersions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: errors.length > 0,
    error: errors,
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 5
    }
  }, targetVersions.map((requiredVersion, index) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TargetVersionsRow, {
      agentsAvailableVersions: (agentsAvailableVersions === null || agentsAvailableVersions === void 0 ? void 0 : agentsAvailableVersions.items) || [],
      requiredVersion: requiredVersion,
      key: requiredVersion.version,
      onRemove: () => onRemove(index),
      onUpdate: (version, percentage) => onUpdate(index, version, percentage),
      agentPolicyId: agentPolicyId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 13
      }
    }));
  }));
};
const TargetVersionsRow = ({
  agentsAvailableVersions,
  requiredVersion,
  onRemove,
  onUpdate,
  agentPolicyId
}) => {
  const options = agentsAvailableVersions.map(version => ({
    value: version,
    inputDisplay: version
  }));
  const [version, setVersion] = (0, _react.useState)(requiredVersion.version);
  const onVersionChange = value => {
    setVersion(value);
  };
  const [percentage, setPercentage] = (0, _react.useState)(requiredVersion.percentage);
  const onPercentageChange = value => {
    setPercentage(value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "stretch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.targetAgentVersionTitle",
      defaultMessage: "Target agent version",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        "data-test-subj": "targetVersionTooltip",
        id: "xpack.fleet.manageAutoUpgradeAgents.targetVersionTooltip",
        defaultMessage: "You can only downgrade agents manually.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 328,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: version,
    onChange: value => {
      onVersionChange(value);
      onUpdate(value, percentage);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.percentageTitle",
      defaultMessage: "% of agents to upgrade",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      title: 'Rounding Applied',
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        "data-test-subj": "percentageTooltip",
        id: "xpack.fleet.manageAutoUpgradeAgents.percentageTooltip",
        defaultMessage: "The actual percentage of agents upgraded may vary slightly due to rounding. For example, selecting 30% of 25 agents may result in 8 agents being upgraded (32%).",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: percentage,
    onChange: e => {
      const newValue = parseInt(e.target.value, 10);
      onPercentageChange(newValue);
      onUpdate(version, newValue);
    },
    min: 1,
    step: 1,
    max: 100,
    required: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.statusTitle",
      defaultMessage: "Status",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status_column.StatusColumn, {
    agentPolicyId: agentPolicyId,
    version: version,
    percentage: percentage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignSelf: 'end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onRemove,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAutoUpgradeAgents.removeVersionButton",
    defaultMessage: "Remove",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 13
    }
  })))));
};