"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HierarchicalActionsMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/hierarchical_actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Recursive menu item interface that supports infinite nesting using EUI's ContextMenu component.
 * If `children` is provided, the item will render as a submenu trigger.
 * If `onClick` is provided (and no children), the item is an action.
 */

/**
 * A reusable hierarchical context menu component that supports infinite nesting.
 * Uses EUI's EuiContextMenu with slide-in panels for nested items.
 */
const HierarchicalActionsMenu = ({
  items,
  isOpen: controlledIsOpen,
  anchorPosition = 'downRight',
  onToggle,
  button,
  'data-test-subj': dataTestSubj
}) => {
  var _button$props, _button$props2, _button$props3, _button$props4;
  const [internalIsOpen, setInternalIsOpen] = (0, _react.useState)(false);

  // Support both controlled and uncontrolled modes
  const isOpen = controlledIsOpen !== undefined ? controlledIsOpen : internalIsOpen;
  const setIsOpen = (0, _react.useCallback)(open => {
    if (onToggle) {
      onToggle(open);
    } else {
      setInternalIsOpen(open);
    }
  }, [onToggle]);
  const closeMenu = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const toggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [setIsOpen, isOpen]);

  /**
   * Recursively converts the MenuItem tree into EUI panel descriptors.
   * Uses item paths as panel IDs (e.g., "reassign.newPolicy") for simplicity.
   * Root panel has ID 0, child panels use their path as the ID.
   */
  const panels = (0, _react.useMemo)(() => {
    const result = [];
    const buildPanels = (menuItems, panelId, parentPanelTitle, parentPath = '') => {
      const panelItems = menuItems.map(item => {
        const itemPath = parentPath ? `${parentPath}.${item.id}` : item.id;
        const hasChildren = item.children && item.children.length > 0;

        // For items with children, only include panel (no onClick)
        // For action items, only include onClick (no panel)
        if (hasChildren) {
          return {
            name: item.name,
            icon: item.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
              type: item.icon,
              size: "m",
              color: item.iconColor,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 118,
                columnNumber: 15
              }
            }) : undefined,
            disabled: item.disabled,
            panel: itemPath,
            'data-test-subj': item['data-test-subj']
          };
        }
        return {
          name: item.name,
          icon: item.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: item.icon,
            size: "m",
            color: item.iconColor,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 129,
              columnNumber: 13
            }
          }) : undefined,
          disabled: item.disabled,
          onClick: event => {
            if (item.onClick) {
              item.onClick(event);
            }
            // Only close the menu if keepMenuOpen is not set to true
            if (!item.keepMenuOpen) {
              closeMenu();
            }
          },
          'data-test-subj': item['data-test-subj']
        };
      });
      const panelDescriptor = {
        id: panelId,
        items: panelItems
      };

      // Add title for child panels - clicking it navigates back
      if (parentPanelTitle) {
        panelDescriptor.title = parentPanelTitle;
      }
      result.push(panelDescriptor);

      // Recursively build child panels
      menuItems.forEach(item => {
        if (item.children && item.children.length > 0) {
          const itemPath = parentPath ? `${parentPath}.${item.id}` : item.id;
          // Use panelTitle if provided, otherwise try to extract string from name
          const childPanelTitle = item.panelTitle || (typeof item.name === 'string' ? item.name : item.id);
          buildPanels(item.children, itemPath, childPanelTitle, itemPath);
        }
      });
    };
    buildPanels(items, 0);
    return result;
  }, [items, closeMenu]);

  // Render the button
  const buttonElement = button ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: (_button$props = button.props) === null || _button$props === void 0 ? void 0 : _button$props.iconType,
    iconSide: (_button$props2 = button.props) === null || _button$props2 === void 0 ? void 0 : _button$props2.iconSide,
    color: (_button$props3 = button.props) === null || _button$props3 === void 0 ? void 0 : _button$props3.color,
    fill: (_button$props4 = button.props) === null || _button$props4 === void 0 ? void 0 : _button$props4.fill,
    onClick: toggleMenu,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, button.children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesHorizontal",
    onClick: toggleMenu,
    "aria-label": _i18n.i18n.translate('xpack.fleet.hierarchicalMenu.openMenuAriaLabel', {
      defaultMessage: 'Open menu'
    }),
    "data-test-subj": dataTestSubj || 'hierarchicalMenuButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    panelPaddingSize: "none",
    button: buttonElement,
    isOpen: isOpen,
    closePopover: closeMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }));
};
exports.HierarchicalActionsMenu = HierarchicalActionsMenu;